package com.qianhe.controller;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.domain.SjFybp;
import com.qianhe.system.domain.SysDeptCb;
import com.qianhe.system.mapper.SysDeptCbMapper;
import com.qianhe.system.mapper.SysDeptMapper;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.SjFybpZb;
import com.qianhe.service.ISjFybpZbService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 三基-费用报批主Controller
 *
 * @author qianhe
 * @date 2024-07-11
 */
@RestController
@RequestMapping("/system/sjFybpZb")
public class SjFybpZbController extends BaseController
{
    @Autowired
    private ISjFybpZbService sjFybpZbService;

    @Autowired
    private SysDeptCbMapper sysDeptCbMapper;
    /**
     * 查询三基-费用报批主列表
     */
    @PreAuthorize("@ss.hasPermi('system:sjFybpZb:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjFybpZb sjFybpZb)
    {
        startPage();
        List<SjFybpZb> list = sjFybpZbService.selectSjFybpZbList(sjFybpZb);
        return getDataTable(list);
    }

    /**
     * 导出三基-费用报批主列表
     */
    @PreAuthorize("@ss.hasPermi('system:sjFybpZb:export')")
    @Log(title = "三基-费用报批主", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjFybpZb sjFybpZb)
    {
        List<SjFybpZb> list = sjFybpZbService.selectSjFybpZbList(sjFybpZb);
        ExcelUtil<SjFybpZb> util = new ExcelUtil<SjFybpZb>(SjFybpZb.class);
        util.exportExcel(response, list, "三基-费用报批主数据");
    }

    /**
     * 获取三基-费用报批主详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:sjFybpZb:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjFybpZbService.selectSjFybpZbById(id));
    }

    /**
     * 新增三基-费用报批主
     */
    @PreAuthorize("@ss.hasPermi('system:sjFybpZb:add')")
    @Log(title = "三基-费用报批主", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjFybpZb sjFybpZb)
    {
        int i = sjFybpZbService.insertSjFybpZb(sjFybpZb);
        SysDeptCb sysDeptCb =new SysDeptCb();
        sysDeptCb.setNd(sjFybpZb.getFyrq());
        sysDeptCb.setDeptId(sjFybpZb.getDeptId());
        SysDeptCb deptCb = sysDeptCbMapper.getInfoBydeptId(sysDeptCb);
        String msg="";
        if(deptCb==null){
            msg="保存成功！您单位基础信息未维护，请到部门管理中进行设置！";
        }else {
           if(StringUtils.isNotEmpty( deptCb.getDwlx() )){
               String dwlx = deptCb.getDwlx();
               BigDecimal jyqlhjysr = deptCb.getJyqlhjysr();//万吨 换算成吨
               BigDecimal jcrysl = BigDecimal.valueOf(deptCb.getJcrysl());
               BigDecimal jcdwsl = BigDecimal.valueOf(deptCb.getJcdwsl());
               BigDecimal yxbzsl = BigDecimal.valueOf(deptCb.getYxbzsl());
               BigDecimal fyje = sjFybpZb.getFyje()!=null?sjFybpZb.getFyje():new BigDecimal(0);
               fyje=fyje.setScale(2,BigDecimal.ROUND_HALF_UP);
               if("油气开发单位".equals(dwlx)){
                   //计算标准
                   jyqlhjysr= deptCb.getJyqlhjysr().multiply(new BigDecimal(10000));//万吨 换算成吨
                   BigDecimal jys= jyqlhjysr.multiply(new BigDecimal(2)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                   BigDecimal rys=jcrysl.multiply(new BigDecimal(1000)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                   BigDecimal dws=jcdwsl.multiply(new BigDecimal(150000)).multiply(new BigDecimal(0.2)).setScale(2,BigDecimal.ROUND_HALF_UP);
                   BigDecimal bzs=yxbzsl.multiply(new BigDecimal(20000)).multiply(new BigDecimal(0.2)).setScale(2,BigDecimal.ROUND_HALF_UP);
                   BigDecimal sum=jys.add(rys).add(dws).add(bzs);
                   sum=sum.divide(new BigDecimal(10000)).setScale(2,BigDecimal.ROUND_HALF_UP);
                   if(fyje.compareTo(sum)>-1){
                     msg="保存成功！费用总额"+fyje+"万元不低于"+sum+"万元。\n计算标准为："
                             +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万吨*2元/吨*30%+"+jcrysl+"*1000元/人*30%+"+jcdwsl+"*15万元/单位*20%+"+yxbzsl+"*2万元/班站*20%="+sum;
                   }else {
                       msg="保存成功！费用总额"+fyje+"万元低于"+sum+"万元。\n计算标准为："
                               +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万吨*2元/吨*30%+"+jcrysl+"*1000元/人*30%+"+jcdwsl+"*15万元/单位*20%+"+yxbzsl+"*2万元/班站*20%="+sum;
                   }
               }else if("主要专业化单位".equals(dwlx)) {
                   //计算标准
                   if(yxbzsl.equals(new BigDecimal(0))){
                       BigDecimal jys= jyqlhjysr.multiply(new BigDecimal(0.0001)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                       BigDecimal rys=jcrysl.multiply(new BigDecimal(1000)).multiply(new BigDecimal(0.4)).setScale(2,BigDecimal.ROUND_HALF_UP);
                       BigDecimal dws=jcdwsl.multiply(new BigDecimal(150000)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                       BigDecimal sum=jys.add(rys).add(dws);
                       sum=sum.divide(new BigDecimal(10000)).setScale(2,BigDecimal.ROUND_HALF_UP);
                       if(fyje.compareTo(sum)>-1){
                           msg="保存成功！费用总额"+fyje+"万元不低于"+sum+"万元。\n计算标准为："
                                   +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万元*1‰*30%+"+jcrysl+"*1000元/人*40%+"+jcdwsl+"*15万元/单位*30%="+sum;
                       }else {
                           msg="保存成功！费用总额"+fyje+"万元低于"+sum+"万元。\n计算标准为："
                                   +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万吨*2元/吨*30%+"+jcrysl+"*1000元/人*40%+"+jcdwsl+"*15万元/单位*30%="+sum;
                       }
                   }else {
                       BigDecimal jys= jyqlhjysr.multiply(new BigDecimal(0.0001)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                       BigDecimal rys=jcrysl.multiply(new BigDecimal(1000)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                       BigDecimal dws=jcdwsl.multiply(new BigDecimal(150000)).multiply(new BigDecimal(0.2)).setScale(2,BigDecimal.ROUND_HALF_UP);
                       BigDecimal bzs=yxbzsl.multiply(new BigDecimal(20000)).multiply(new BigDecimal(0.2)).setScale(2,BigDecimal.ROUND_HALF_UP);
                       BigDecimal sum=jys.add(rys).add(dws).add(bzs);
                       sum=sum.divide(new BigDecimal(10000)).setScale(2,BigDecimal.ROUND_HALF_UP);
                       if(fyje.compareTo(sum)>-1){
                           msg="保存成功！费用总额"+fyje+"万元不低于"+sum+"万元。\n计算标准为："
                                   +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万元*1‰*30%+"+jcrysl+"*1000元/人*30%+"+jcdwsl+"*15万元/单位*20%+"+yxbzsl+"*2万元/班站*20%="+sum;
                       }else {
                           msg="保存成功！费用总额"+fyje+"万元低于"+sum+"万元。\n计算标准为："
                                   +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万吨*2元/吨*30%+"+jcrysl+"*1000元/人*30%+"+jcdwsl+"*15万元/单位*20%+"+yxbzsl+"*2万元/班站*20%="+sum;
                       }

                   }
               }else if("科研、监督、服务协调单位".equals(dwlx)) {
                   BigDecimal jys= jyqlhjysr.multiply(new BigDecimal(0.0001)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                   BigDecimal rys=jcrysl.multiply(new BigDecimal(1000)).multiply(new BigDecimal(0.4)).setScale(2,BigDecimal.ROUND_HALF_UP);
                   BigDecimal dws=jcdwsl.multiply(new BigDecimal(50000)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                   BigDecimal sum=jys.add(rys).add(dws);
                   sum=sum.divide(new BigDecimal(10000)).setScale(2,BigDecimal.ROUND_HALF_UP);
                   if(fyje.compareTo(sum)>-1){
                       msg="保存成功！费用总额"+fyje+"万元不低于"+sum+"万元。\n计算标准为："
                               +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万元*1‰*30%+"+jcrysl+"*1000元/人*40%+"+jcdwsl+"*5万元/单位*30%="+sum;
                   }else {
                       msg="保存成功！费用总额"+fyje+"万元低于"+sum+"万元。\n计算标准为："
                               +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万吨*2元/吨*30%+"+jcrysl+"*1000元/人*40%+"+jcdwsl+"*5万元/单位*30%="+sum;
                   }
               }
           }
        }
        return AjaxResult.success(msg);
    }

    /**
     * 修改三基-费用报批主
     */
    @PreAuthorize("@ss.hasPermi('system:sjFybpZb:edit')")
    @Log(title = "三基-费用报批主", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjFybpZb sjFybpZb)
    {
        int i = sjFybpZbService.updateSjFybpZb(sjFybpZb);
        SysDeptCb sysDeptCb =new SysDeptCb();
        sysDeptCb.setNd(sjFybpZb.getFyrq());
        sysDeptCb.setDeptId(sjFybpZb.getDeptId());
        SysDeptCb deptCb = sysDeptCbMapper.getInfoBydeptId(sysDeptCb);
        String msg="";
        if(deptCb==null){
            msg="保存成功！您单位基础信息未维护，请到部门管理中进行设置！";
        }else {
            if(StringUtils.isNotEmpty( deptCb.getDwlx() )){
                String dwlx = deptCb.getDwlx();
                BigDecimal jyqlhjysr = deptCb.getJyqlhjysr();//万吨 换算成吨
                BigDecimal jcrysl = BigDecimal.valueOf(deptCb.getJcrysl());
                BigDecimal jcdwsl = BigDecimal.valueOf(deptCb.getJcdwsl());
                BigDecimal yxbzsl = BigDecimal.valueOf(deptCb.getYxbzsl());
                BigDecimal fyje = sjFybpZb.getFyje()!=null?sjFybpZb.getFyje():new BigDecimal(0);
                fyje=fyje.setScale(2,BigDecimal.ROUND_HALF_UP);
                if("油气开发单位".equals(dwlx)){
                    //计算标准
                    jyqlhjysr= deptCb.getJyqlhjysr().multiply(new BigDecimal(10000));//万吨 换算成吨
                    BigDecimal jys= jyqlhjysr.multiply(new BigDecimal(2)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal rys=jcrysl.multiply(new BigDecimal(1000)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal dws=jcdwsl.multiply(new BigDecimal(150000)).multiply(new BigDecimal(0.2)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal bzs=yxbzsl.multiply(new BigDecimal(20000)).multiply(new BigDecimal(0.2)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal sum=jys.add(rys).add(dws).add(bzs);
                    sum=sum.divide(new BigDecimal(10000)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    if(fyje.compareTo(sum)>-1){
                        msg="保存成功！费用总额"+fyje+"万元不低于"+sum+"万元。\n计算标准为："
                                +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万吨*2元/吨*30%+"+jcrysl+"*1000元/人*30%+"+jcdwsl+"*15万元/单位*20%+"+yxbzsl+"*2万元/班站*20%="+sum;
                    }else {
                        msg="保存成功！费用总额"+fyje+"万元低于"+sum+"万元。\n计算标准为："
                                +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万吨*2元/吨*30%+"+jcrysl+"*1000元/人*30%+"+jcdwsl+"*15万元/单位*20%+"+yxbzsl+"*2万元/班站*20%="+sum;
                    }
                }else if("主要专业化单位".equals(dwlx)) {
                    //计算标准
                    if(yxbzsl.equals(new BigDecimal(0))){
                        BigDecimal jys= jyqlhjysr.multiply(new BigDecimal(0.0001)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal rys=jcrysl.multiply(new BigDecimal(1000)).multiply(new BigDecimal(0.4)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal dws=jcdwsl.multiply(new BigDecimal(150000)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal sum=jys.add(rys).add(dws);
                        sum=sum.divide(new BigDecimal(10000)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        if(fyje.compareTo(sum)>-1){
                            msg="保存成功！费用总额"+fyje+"万元不低于"+sum+"万元。\n计算标准为："
                                    +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万元*1‰*30%+"+jcrysl+"*1000元/人*40%+"+jcdwsl+"*15万元/单位*30%="+sum;
                        }else {
                            msg="保存成功！费用总额"+fyje+"万元低于"+sum+"万元。\n计算标准为："
                                    +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万吨*2元/吨*30%+"+jcrysl+"*1000元/人*40%+"+jcdwsl+"*15万元/单位*30%="+sum;
                        }
                    }else {
                        BigDecimal jys= jyqlhjysr.multiply(new BigDecimal(0.0001)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal rys=jcrysl.multiply(new BigDecimal(1000)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal dws=jcdwsl.multiply(new BigDecimal(150000)).multiply(new BigDecimal(0.2)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal bzs=yxbzsl.multiply(new BigDecimal(20000)).multiply(new BigDecimal(0.2)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal sum=jys.add(rys).add(dws).add(bzs);
                        sum=sum.divide(new BigDecimal(10000)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        if(fyje.compareTo(sum)>-1){
                            msg="保存成功！费用总额"+fyje+"万元不低于"+sum+"万元。\n计算标准为："
                                    +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万元*1‰*30%+"+jcrysl+"*1000元/人*30%+"+jcdwsl+"*15万元/单位*20%+"+yxbzsl+"*2万元/班站*20%="+sum;
                        }else {
                            msg="保存成功！费用总额"+fyje+"万元低于"+sum+"万元。\n计算标准为："
                                    +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万吨*2元/吨*30%+"+jcrysl+"*1000元/人*30%+"+jcdwsl+"*15万元/单位*20%+"+yxbzsl+"*2万元/班站*20%="+sum;
                        }

                    }
                }else if("科研、监督、服务协调单位".equals(dwlx)) {
                    BigDecimal jys= jyqlhjysr.multiply(new BigDecimal(0.0001)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal rys=jcrysl.multiply(new BigDecimal(1000)).multiply(new BigDecimal(0.4)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal dws=jcdwsl.multiply(new BigDecimal(50000)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal sum=jys.add(rys).add(dws);
                    sum=sum.divide(new BigDecimal(10000)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    if(fyje.compareTo(sum)>-1){
                        msg="保存成功！费用总额"+fyje+"万元不低于"+sum+"万元。\n计算标准为："
                                +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万元*1‰*30%+"+jcrysl+"*1000元/人*40%+"+jcdwsl+"*5万元/单位*30%="+sum;
                    }else {
                        msg="保存成功！费用总额"+fyje+"万元低于"+sum+"万元。\n计算标准为："
                                +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万吨*2元/吨*30%+"+jcrysl+"*1000元/人*40%+"+jcdwsl+"*5万元/单位*30%="+sum;
                    }
                }
            }
        }
        return AjaxResult.success(msg);
    }

    /**
     * 删除三基-费用报批主
     */
    @PreAuthorize("@ss.hasPermi('system:sjFybpZb:remove')")
    @Log(title = "三基-费用报批主", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjFybpZbService.deleteSjFybpZbByIds(ids));
    }



    /**
     * 提交
     */
    @Log(title = "三基-费用报批", businessType = BusinessType.UPDATE)
    @PostMapping("/tj")
    public AjaxResult tj(@RequestBody SjFybpZb sjFybpZb)
    {
        sjFybpZb.setTjr(SecurityUtils.getUsername());
        sjFybpZb.setTjrq(DateUtils.dateTimeNow("yyyy-MM-dd HH:mm:ss"));
        return toAjax(sjFybpZbService.tj(sjFybpZb));
    }


    /**
     * 提交
     */
    @Log(title = "三基-费用报批", businessType = BusinessType.UPDATE)
    @PostMapping("/sp")
    public AjaxResult sp(@RequestBody SjFybpZb sjFybpZb)
    {
        sjFybpZb.setSpr(SecurityUtils.getUsername());
        sjFybpZb.setSprq(DateUtils.dateTimeNow("yyyy-MM-dd HH:mm:ss"));
        return toAjax(sjFybpZbService.tj(sjFybpZb));
    }

    @GetMapping("/splist")
    public TableDataInfo splist(SjFybpZb sjFybpZb)
    {
        startPage();
        sjFybpZb.setSpcx("1");
        List<SjFybpZb> list = sjFybpZbService.selectSjFybpZbList(sjFybpZb);
        return getDataTable(list);
    }


    /**
     * 获取三基-费用报批主详细信息
     */
//    @PreAuthorize("@ss.hasPermi('system:sjFybpZb:query')")
    @GetMapping(value = "/getInfoBySp/{id}")
    public AjaxResult getInfoBySp(@PathVariable("id") Long id)
    {
        SjFybpZb sjFybpZb = sjFybpZbService.selectSjFybpZbById(id);
        SysDeptCb sysDeptCb =new SysDeptCb();
        sysDeptCb.setNd(sjFybpZb.getFyrq());
        sysDeptCb.setDeptId(sjFybpZb.getDeptId());
        SysDeptCb deptCb = sysDeptCbMapper.getInfoBydeptId(sysDeptCb);
        if(deptCb==null){
            sjFybpZb.setJl("您单位基础信息未维护，请到部门管理中进行设置！");
        }else {
            if(StringUtils.isNotEmpty( deptCb.getDwlx() )){
                String dwlx = deptCb.getDwlx();
                BigDecimal jyqlhjysr = deptCb.getJyqlhjysr();//万吨 换算成吨
                BigDecimal jcrysl = BigDecimal.valueOf(deptCb.getJcrysl());
                BigDecimal jcdwsl = BigDecimal.valueOf(deptCb.getJcdwsl());
                BigDecimal yxbzsl = BigDecimal.valueOf(deptCb.getYxbzsl());
                BigDecimal fyje = sjFybpZb.getFyje()!=null?sjFybpZb.getFyje():new BigDecimal(0);
                fyje=fyje.setScale(2,BigDecimal.ROUND_HALF_UP);
                if("油气开发单位".equals(dwlx)){
                    //计算标准
                    jyqlhjysr= deptCb.getJyqlhjysr().multiply(new BigDecimal(10000));//万吨 换算成吨
                    BigDecimal jys= jyqlhjysr.multiply(new BigDecimal(2)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal rys=jcrysl.multiply(new BigDecimal(1000)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal dws=jcdwsl.multiply(new BigDecimal(150000)).multiply(new BigDecimal(0.2)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal bzs=yxbzsl.multiply(new BigDecimal(20000)).multiply(new BigDecimal(0.2)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal sum=jys.add(rys).add(dws).add(bzs);
                    sum=sum.divide(new BigDecimal(10000)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    if(fyje.compareTo(sum)>-1){
                        sjFybpZb.setJl("费用总额"+fyje+"万元不低于"+sum+"万元。");
                        sjFybpZb.setJlflag(true);
                    }else {
                        sjFybpZb.setJl("费用总额"+fyje+"万元低于"+sum+"万元。");
                        sjFybpZb.setJlflag(false);
                    }
                    sjFybpZb.setJsbz("计算标准为："
                            +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万吨*2元/吨*30%+"+jcrysl+"*1000元/人*30%+"+jcdwsl+"*15万元/单位*20%+"+yxbzsl+"*2万元/班站*20%="+sum);
                    sjFybpZb.setTqbz("交油气量（万吨）×2 元/吨×30%+基层人员数量×1000 元/人×30%+\n" +
                            "基层单位数量×15 万元/单位×20%+一线班站数量×2 万元/班站×20%");

                }else if("主要专业化单位".equals(dwlx)) {
                    //计算标准
                    if(yxbzsl.equals(new BigDecimal(0))){
                        BigDecimal jys= jyqlhjysr.multiply(new BigDecimal(0.0001)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal rys=jcrysl.multiply(new BigDecimal(1000)).multiply(new BigDecimal(0.4)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal dws=jcdwsl.multiply(new BigDecimal(150000)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal sum=jys.add(rys).add(dws);
                        sum=sum.divide(new BigDecimal(10000)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        if(fyje.compareTo(sum)>-1){
                            sjFybpZb.setJl("费用总额"+fyje+"万元不低于"+sum+"万元。");
                            sjFybpZb.setJlflag(true);
                        }else {
                            sjFybpZb.setJl("费用总额"+fyje+"万元低于"+sum+"万元。");
                            sjFybpZb.setJlflag(false);
                        }
                        sjFybpZb.setJsbz("计算标准为："
                                +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万吨*2元/吨*30%+"+jcrysl+"*1000元/人*40%+"+jcdwsl+"*15万元/单位*30%="+sum);
                        sjFybpZb.setTqbz("经营收入（万元）×1‰×30%+基层人员数量×1000 元/人×40%+基层\n" +
                                "单位数量×15 万元/单位×30%");
                    }else {
                        BigDecimal jys= jyqlhjysr.multiply(new BigDecimal(0.0001)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal rys=jcrysl.multiply(new BigDecimal(1000)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal dws=jcdwsl.multiply(new BigDecimal(150000)).multiply(new BigDecimal(0.2)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal bzs=yxbzsl.multiply(new BigDecimal(20000)).multiply(new BigDecimal(0.2)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal sum=jys.add(rys).add(dws).add(bzs);
                        sum=sum.divide(new BigDecimal(10000)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        if(fyje.compareTo(sum)>-1){
                            sjFybpZb.setJl("费用总额"+fyje+"万元不低于"+sum+"万元。");
                            sjFybpZb.setJlflag(true);
                        }else {
                            sjFybpZb.setJl("费用总额"+fyje+"万元低于"+sum+"万元。");
                            sjFybpZb.setJlflag(false);
                        }
                        sjFybpZb.setJsbz("计算标准为："
                                +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万吨*2元/吨*30%+"+jcrysl+"*1000元/人*30%+"+jcdwsl+"*15万元/单位*20%+"+yxbzsl+"*2万元/班站*20%="+sum);
                        sjFybpZb.setTqbz("经营收入（万元）×1‰×30%+基层人员数量×1000 元/人×30%+基层\n" +
                                "单位数量×15 万元/单位×20%+一线班站数量×2 万元/班站×20%");
                    }
                }else if("科研、监督、服务协调单位".equals(dwlx)) {
                    BigDecimal jys= jyqlhjysr.multiply(new BigDecimal(0.0001)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal rys=jcrysl.multiply(new BigDecimal(1000)).multiply(new BigDecimal(0.4)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal dws=jcdwsl.multiply(new BigDecimal(50000)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal sum=jys.add(rys).add(dws);
                    sum=sum.divide(new BigDecimal(10000)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    if(fyje.compareTo(sum)>-1){
                        sjFybpZb.setJl("费用总额"+fyje+"万元不低于"+sum+"万元。");
                        sjFybpZb.setJlflag(true);
                    }else {
                        sjFybpZb.setJl("费用总额"+fyje+"万元低于"+sum+"万元。");
                        sjFybpZb.setJlflag(false);
                    }
                    sjFybpZb.setJsbz("计算标准为："
                            +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万吨*2元/吨*30%+"+jcrysl+"*1000元/人*40%+"+jcdwsl+"*5万元/单位*30%="+sum);
                    sjFybpZb.setTqbz("经营收入（万元）×1‰×30%+基层人员数量×1000 元/人×40%+基层\n" +
                            "单位数量×5 万元/单位×30%");
                }
            }
        }

        return success(sjFybpZb);
    }

}
