package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.domain.JygxLxwh;
import com.qianhe.service.IJygxLxwhService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;

import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 经验共享-类型维护Controller
 *
 * @author qianhe
 * @date 2024-07-29
 */
@RestController
@RequestMapping("/system/lxwh")
public class JygxLxwhController extends BaseController
{
    @Autowired
    private IJygxLxwhService jygxLxwhService;

    /**
     * 查询经验共享-类型维护列表
     */
    @PreAuthorize("@ss.hasPermi('system:lxwh:list')")
    @GetMapping("/list")
    public TableDataInfo list(JygxLxwh jygxLxwh)
    {
        startPage();
        List<JygxLxwh> list = jygxLxwhService.selectJygxLxwhList(jygxLxwh);
        return getDataTable(list);
    }

    /**
     * 导出经验共享-类型维护列表
     */
    @PreAuthorize("@ss.hasPermi('system:lxwh:export')")
    @Log(title = "经验共享-类型维护", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, JygxLxwh jygxLxwh)
    {
        List<JygxLxwh> list = jygxLxwhService.selectJygxLxwhList(jygxLxwh);
        ExcelUtil<JygxLxwh> util = new ExcelUtil<JygxLxwh>(JygxLxwh.class);
        util.exportExcel(response, list, "经验共享-类型维护数据");
    }

    /**
     * 获取经验共享-类型维护详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:lxwh:query')")
    @GetMapping(value = "/{lxid}")
    public AjaxResult getInfo(@PathVariable("lxid") Long lxid)
    {
        return success(jygxLxwhService.selectJygxLxwhByLxid(lxid));
    }

    /**
     * 新增经验共享-类型维护
     */
    @PreAuthorize("@ss.hasPermi('system:lxwh:add')")
    @Log(title = "经验共享-类型维护", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody JygxLxwh jygxLxwh)
    {
        return toAjax(jygxLxwhService.insertJygxLxwh(jygxLxwh));
    }

    /**
     * 修改经验共享-类型维护
     */
    @PreAuthorize("@ss.hasPermi('system:lxwh:edit')")
    @Log(title = "经验共享-类型维护", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody JygxLxwh jygxLxwh)
    {
        return toAjax(jygxLxwhService.updateJygxLxwh(jygxLxwh));
    }

    /**
     * 删除经验共享-类型维护
     */
    @PreAuthorize("@ss.hasPermi('system:lxwh:remove')")
    @Log(title = "经验共享-类型维护", businessType = BusinessType.DELETE)
	@DeleteMapping("/{lxids}")
    public AjaxResult remove(@PathVariable Long[] lxids)
    {
        return toAjax(jygxLxwhService.deleteJygxLxwhByLxids(lxids));
    }
}
