package com.qianhe.service.impl;

import java.math.BigDecimal;
import java.util.List;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.domain.SjFybpWh;
import com.qianhe.domain.WdWdxx;
import com.qianhe.mapper.SjFybpMapper;
import com.qianhe.mapper.WdWdxxMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import com.qianhe.common.utils.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import com.qianhe.domain.SjFybp;
import com.qianhe.mapper.SjFybpZbMapper;
import com.qianhe.domain.SjFybpZb;
import com.qianhe.service.ISjFybpZbService;

/**
 * 三基-费用报批主Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-11
 */
@Service
public class SjFybpZbServiceImpl implements ISjFybpZbService
{
    @Autowired
    private SjFybpZbMapper sjFybpZbMapper;
    @Autowired
    private SjFybpMapper sjFybpMapper;

    @Autowired
    private WdWdxxMapper wdWdxxMapper;
    /**
     * 查询三基-费用报批主
     *
     * @param id 三基-费用报批主主键
     * @return 三基-费用报批主
     */
    @Override
    public SjFybpZb selectSjFybpZbById(Long id)
    {

        SjFybpZb sjFybpZb = sjFybpZbMapper.selectSjFybpZbById(id);
        //查询从表
        List<SjFybp> sjFybpList=sjFybpMapper.selectSjFybpByZbId(id);
        sjFybpZb.setSjFybpList(sjFybpList);
        //查询文件
        //查询文档
        WdWdxx wdWdxx=new WdWdxx();
        wdWdxx.setGlId(sjFybpZb.getId().toString());
        wdWdxx.setMkmc("费用报批");
        wdWdxx.setFjlx("费用上报");
        List<WdWdxx> wdWdxxes = wdWdxxMapper.selectWdWdxxList(wdWdxx);
        sjFybpZb.setFileList(wdWdxxes);

        return sjFybpZb;
    }

    /**
     * 查询三基-费用报批主列表
     *
     * @param sjFybpZb 三基-费用报批主
     * @return 三基-费用报批主
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjFybpZb> selectSjFybpZbList(SjFybpZb sjFybpZb)
    {
        return sjFybpZbMapper.selectSjFybpZbList(sjFybpZb);
    }

    @Override
    public List<SjFybpZb> selectSjFybpZbList_main(SjFybpZb sjFybpZb)
    {
        return sjFybpZbMapper.selectSjFybpZbList_main(sjFybpZb);
    }

    /**
     * 新增三基-费用报批主
     *
     * @param sjFybpZb 三基-费用报批主
     * @return 结果
     */
    @Transactional
    @Override
    public int insertSjFybpZb(SjFybpZb sjFybpZb)
    {

        //保存金额
        if(StringUtils.isNotEmpty(sjFybpZb.getSjFybpList())){
            //统计已结算金额
            BigDecimal reduce = sjFybpZb.getSjFybpList().stream().map(SjFybp::getFyje).reduce(BigDecimal.ZERO, BigDecimal::add);
            sjFybpZb.setFyje(reduce);
        }
        sjFybpZb.setCreateTime(DateUtils.getNowDate());
        int rows = sjFybpZbMapper.insertSjFybpZb(sjFybpZb);
        insertSjFybp(sjFybpZb);
        //保存文件
        if(StringUtils.isNotEmpty(sjFybpZb.getFileList())){
            if(sjFybpZb.getFileList().size()>0){
                sjFybpZb.getFileList().forEach(file->{
                    file.setGlId(sjFybpZb.getId().toString());
                    file.setMkmc("费用报批");
                    file.setFjlx("费用上报");
                    file.setLrr(SecurityUtils.getUsername());
                    wdWdxxMapper.insertWdWdxx(file);
                });
            }
        }
        return rows;
    }

    /**
     * 修改三基-费用报批主
     *
     * @param sjFybpZb 三基-费用报批主
     * @return 结果
     */
    @Transactional
    @Override
    public int updateSjFybpZb(SjFybpZb sjFybpZb)
    {
        //先删除文件
        wdWdxxMapper.deleteWdWdxxByGlIdAndMkmc(sjFybpZb.getId()+"","费用报批");
        //保存文件
        if(StringUtils.isNotEmpty(sjFybpZb.getFileList())){
            if(sjFybpZb.getFileList().size()>0){
                sjFybpZb.getFileList().forEach(file->{
                    file.setGlId(sjFybpZb.getId().toString());
                    file.setMkmc("费用报批");
                    file.setFjlx("费用上报");
                    file.setLrr(SecurityUtils.getUsername());
                    wdWdxxMapper.insertWdWdxx(file);
                });
            }
        }
        //保存金额
        if(StringUtils.isNotEmpty(sjFybpZb.getSjFybpList())){
            //统计已结算金额
            BigDecimal reduce = sjFybpZb.getSjFybpList().stream().map(SjFybp::getFyje).reduce(BigDecimal.ZERO, BigDecimal::add);
            sjFybpZb.setFyje(reduce);
        }
        sjFybpZb.setUpdateTime(DateUtils.getNowDate());
        sjFybpZbMapper.deleteSjFybpByZbId(sjFybpZb.getId());
        insertSjFybp(sjFybpZb);
        return sjFybpZbMapper.updateSjFybpZb(sjFybpZb);
    }

    /**
     * 批量删除三基-费用报批主
     *
     * @param ids 需要删除的三基-费用报批主主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSjFybpZbByIds(Long[] ids)
    {
        sjFybpZbMapper.deleteSjFybpByZbIds(ids);
        return sjFybpZbMapper.deleteSjFybpZbByIds(ids);
    }

    /**
     * 删除三基-费用报批主信息
     *
     * @param id 三基-费用报批主主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSjFybpZbById(Long id)
    {
        sjFybpZbMapper.deleteSjFybpByZbId(id);
        return sjFybpZbMapper.deleteSjFybpZbById(id);
    }

    @Override
    public int tj(SjFybpZb sjFybpZb) {
        return sjFybpZbMapper.updateSjFybpZb(sjFybpZb);
    }

    /**
     * 新增三基-费用报批信息
     *
     * @param sjFybpZb 三基-费用报批主对象
     */
    public void insertSjFybp(SjFybpZb sjFybpZb)
    {
        List<SjFybp> sjFybpList = sjFybpZb.getSjFybpList();
        Long id = sjFybpZb.getId();
        if (StringUtils.isNotNull(sjFybpList))
        {
            List<SjFybp> list = new ArrayList<SjFybp>();
            for (SjFybp sjFybp : sjFybpList)
            {
                sjFybp.setZbId(id);
                list.add(sjFybp);
            }
            if (list.size() > 0)
            {
                sjFybpZbMapper.batchSjFybp(list);
            }
        }
    }
}
