package com.qianhe.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.qianhe.mapper.SjFybpWhMapper;
import com.qianhe.domain.SjFybpWh;
import com.qianhe.service.ISjFybpWhService;

/**
 * 三基-费用维护Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-05
 */
@Service
public class SjFybpWhServiceImpl implements ISjFybpWhService
{
    @Autowired
    private SjFybpWhMapper sjFybpWhMapper;

    /**
     * 查询三基-费用维护
     *
     * @param id 三基-费用维护主键
     * @return 三基-费用维护
     */
    @Override
    public SjFybpWh selectSjFybpWhById(Long id)
    {
        return sjFybpWhMapper.selectSjFybpWhById(id);
    }

    /**
     * 查询三基-费用维护列表
     *
     * @param sjFybpWh 三基-费用维护
     * @return 三基-费用维护
     */
    @Override
    public List<SjFybpWh> selectSjFybpWhList(SjFybpWh sjFybpWh)
    {
        return sjFybpWhMapper.selectSjFybpWhList(sjFybpWh);
    }

    /**
     * 新增三基-费用维护
     *
     * @param sjFybpWh 三基-费用维护
     * @return 结果
     */
    @Override
    public int insertSjFybpWh(SjFybpWh sjFybpWh)
    {
        return sjFybpWhMapper.insertSjFybpWh(sjFybpWh);
    }

    /**
     * 修改三基-费用维护
     *
     * @param sjFybpWh 三基-费用维护
     * @return 结果
     */
    @Override
    public int updateSjFybpWh(SjFybpWh sjFybpWh)
    {
        return sjFybpWhMapper.updateSjFybpWh(sjFybpWh);
    }

    /**
     * 批量删除三基-费用维护
     *
     * @param ids 需要删除的三基-费用维护主键
     * @return 结果
     */
    @Override
    public int deleteSjFybpWhByIds(Long[] ids)
    {
        return sjFybpWhMapper.deleteSjFybpWhByIds(ids);
    }

    /**
     * 删除三基-费用维护信息
     *
     * @param id 三基-费用维护主键
     * @return 结果
     */
    @Override
    public int deleteSjFybpWhById(Long id)
    {
        return sjFybpWhMapper.deleteSjFybpWhById(id);
    }
}
