package com.qianhe.service.impl;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.core.domain.entity.SysDept;
import com.qianhe.common.core.domain.entity.SysDictData;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.domain.*;
import com.qianhe.mapper.SjGfjsZsdwkhpjMapper;
import com.qianhe.mapper.SjGfjsZsdwkhpjZbMapper;
import com.qianhe.service.ISjGfjsDxjczService;
import com.qianhe.service.ISjGfjsFdgzService;
import com.qianhe.service.ISjGfjsZdgzService;
import com.qianhe.service.ISjGfjsZsdwkhpjService;
import com.qianhe.system.mapper.SysDeptMapper;
import com.qianhe.system.mapper.SysDictDataMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 规范建设-直属单位考核评价Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-24
 */
@Service
public class SjGfjsZsdwkhpjServiceImpl implements ISjGfjsZsdwkhpjService
{
    @Autowired
    private SjGfjsZsdwkhpjMapper sjGfjsZsdwkhpjMapper;
    @Autowired
    private SjGfjsZsdwkhpjZbMapper sjGfjsZsdwkhpjZbMapper;
    @Autowired
    private SysDictDataMapper sysDictDataMapper;
    @Autowired
    private SysDeptMapper sysDeptMapper;

    /**
     * 查询规范建设-直属单位考核评价
     *
     * @param id 规范建设-直属单位考核评价主键
     * @return 规范建设-直属单位考核评价
     */
    @Override
    public SjGfjsZsdwkhpj selectSjGfjsZsdwkhpjById(Long id)
    {
        return sjGfjsZsdwkhpjMapper.selectSjGfjsZsdwkhpjById(id);
    }

    /**
     * 查询规范建设-直属单位考核评价列表
     *
     * @param sjGfjsZsdwkhpj 规范建设-直属单位考核评价
     * @return 规范建设-直属单位考核评价
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjGfjsZsdwkhpj> selectSjGfjsZsdwkhpjList(SjGfjsZsdwkhpj sjGfjsZsdwkhpj)
    {
        return sjGfjsZsdwkhpjMapper.selectSjGfjsZsdwkhpjList(sjGfjsZsdwkhpj);
    }

    /**
     * 新增规范建设-直属单位考核评价
     *
     * @param sjGfjsZsdwkhpj 规范建设-直属单位考核评价
     * @return 结果
     */
    @Override
    public int insertSjGfjsZsdwkhpj(SjGfjsZsdwkhpj sjGfjsZsdwkhpj)
    {
        sjGfjsZsdwkhpj.setCreateTime(DateUtils.getNowDate());
        return sjGfjsZsdwkhpjMapper.insertSjGfjsZsdwkhpj(sjGfjsZsdwkhpj);
    }

    /**
     * 修改规范建设-直属单位考核评价
     *
     * @param sjGfjsZsdwkhpj 规范建设-直属单位考核评价
     * @return 结果
     */
    @Override
    public int updateSjGfjsZsdwkhpj(SjGfjsZsdwkhpj sjGfjsZsdwkhpj)
    {
        sjGfjsZsdwkhpj.setUpdateTime(DateUtils.getNowDate());
        sjGfjsZsdwkhpj.setUpdateBy(SecurityUtils.getUsername());
        //计算分数
        return sjGfjsZsdwkhpjMapper.updateSjGfjsZsdwkhpj(sjGfjsZsdwkhpj);
    }

    /**
     * 批量删除规范建设-直属单位考核评价
     *
     * @param ids 需要删除的规范建设-直属单位考核评价主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsZsdwkhpjByIds(Long[] ids)
    {
        return sjGfjsZsdwkhpjMapper.deleteSjGfjsZsdwkhpjByIds(ids);
    }

    /**
     * 删除规范建设-直属单位考核评价信息
     *
     * @param id 规范建设-直属单位考核评价主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsZsdwkhpjById(Long id)
    {
        return sjGfjsZsdwkhpjMapper.deleteSjGfjsZsdwkhpjById(id);
    }

    @Override
    public int batchSave(List<SjGfjsZsdwkhpj> addList) {
        return sjGfjsZsdwkhpjMapper.batchSave(addList);
    }


    @Autowired
    private ISjGfjsZdgzService sjGfjsZdgzService;
    @Autowired
    private ISjGfjsDxjczService sjGfjsDxjczService;
    @Autowired
    private ISjGfjsFdgzService sjGfjsFdgzService;
    // 定义默认的最大值
    private static final BigDecimal DEFAULT_MAX = new BigDecimal("99999");
    // 定义默认的最小值
    private static final BigDecimal DEFAULT_MIN = BigDecimal.ZERO;
    @Override
    public int pledit(List<SjGfjsZsdwkhpj> list) {
        //计算分数
        SjGfjsZsdwkhpj sjGfjsZsdwkhpj = list.get(0);
        SjGfjsZsdwkhpjZb sjGfjsZsdwkhpjZb = sjGfjsZsdwkhpjZbMapper.selectSjGfjsZsdwkhpjZbById(sjGfjsZsdwkhpj.getZbId());

        String nd = sjGfjsZsdwkhpjZb.getNd();
        //  查询权重系数，
        SjGfjsZdgz sjGfjsZdgz_qz = new SjGfjsZdgz();
        sjGfjsZdgz_qz.setNd(nd);
        sjGfjsZdgz_qz.setLx("基础");
        List<SjGfjsZdgz> qzlist = sjGfjsZdgzService.selectSjGfjsZdgzList(sjGfjsZdgz_qz);
        //  查询基础值，
        SjGfjsDxjcz sjGfjsDxjcz  = new SjGfjsDxjcz();
        sjGfjsDxjcz.setNd(nd);
        List<SjGfjsDxjcz> jczlist = sjGfjsDxjczService.selectSjGfjsDxjczList(sjGfjsDxjcz);
        Map<String, BigDecimal> jczMap = new HashMap<>();
        for (SjGfjsDxjcz dxjcz : jczlist) {
            try {
                // 将基础值字符串转换为BigDecimal
                BigDecimal jczValue = new BigDecimal(dxjcz.getJcz());
                jczMap.put(dxjcz.getJb(), jczValue);
            } catch (NumberFormatException e) {
                throw new IllegalArgumentException("基础值格式错误，级别：" + dxjcz.getJb() + "，值：" + dxjcz.getJcz(), e);
            }
        }
        //  分档规则
        SjGfjsFdgz sjGfjsFdgz  = new SjGfjsFdgz();
        sjGfjsFdgz.setNd(nd);
        List<SjGfjsFdgz> fdgzlist = sjGfjsFdgzService.selectSjGfjsFdgzList(sjGfjsFdgz);


        // 计算总得分
        BigDecimal totalScore = BigDecimal.ZERO;
        for(int i=0;i<qzlist.size();i++){
            SjGfjsZdgz qzxsMap = qzlist.get(i);
            BigDecimal qzxs = new BigDecimal(qzxsMap.getKhnrfs());// 系数
            String  khxd = qzxsMap.getKhxd();

            List<SjGfjsZsdwkhpj> filteredDetails = list.stream().filter(item -> khxd.equals(item.getKhxd())).collect(Collectors.toList());

            // 计算小项得分总和
            BigDecimal xmTotal = BigDecimal.ZERO;
            int validCount = 0;
            for (SjGfjsZsdwkhpj detail : filteredDetails) {
                String khfz = detail.getKhfz(); // 小项ABCD结果
                BigDecimal jcz = jczMap.get(khfz);
                xmTotal = xmTotal.add(jcz);
                validCount++;
            }
            // 计算小项平均分（如果没有有效小项，得分为0）
            BigDecimal avgScore = BigDecimal.ZERO;
            if (validCount > 0) {
                avgScore = xmTotal.divide(new BigDecimal(validCount), 2, RoundingMode.HALF_UP);
            }

            // 计算单项得分并累加
            BigDecimal itemScore = qzxs.multiply(avgScore);
            totalScore = totalScore.add(itemScore);
        }

        //  计算单位分档级别
        String fdjb = "未知";
        for (SjGfjsFdgz fdgz : fdgzlist) {
            // 处理最小基础值（null或空字符串视为0）
            BigDecimal minJcz = DEFAULT_MIN;
            String minStr = fdgz.getMinjcz();
            if (minStr != null && !minStr.trim().isEmpty()) {
                minJcz = new BigDecimal(minStr.trim());
            }

            // 处理最大基础值（null或空字符串视为99999）
            BigDecimal maxJcz = DEFAULT_MAX;
            String maxStr = fdgz.getMaxjcz();
            if (maxStr != null && !maxStr.trim().isEmpty()) {
                maxJcz = new BigDecimal(maxStr.trim());
            }

            // 检查总分是否在当前分档的范围内（包含边界值）
            // 比较规则：minJcz ≤ totalScore < maxJcz
            if (totalScore.compareTo(minJcz) >= 0 && totalScore.compareTo(maxJcz) < 0) {
                fdjb = fdgz.getJb(); // 返回匹配的级别
            }
        }
        sjGfjsZsdwkhpjZb.setZdf(totalScore);
        sjGfjsZsdwkhpjZb.setZhdf(totalScore);
        sjGfjsZsdwkhpjZb.setFdjb(fdjb);

        //更新主表
        sjGfjsZsdwkhpjZbMapper.updateSjGfjsZsdwkhpjZb(sjGfjsZsdwkhpjZb);
        //更新详情
        int mxint = sjGfjsZsdwkhpjMapper.pledit(list);

         // 更新本单位的排名
      /*  String zqfw = sjGfjsZsdwkhpjZb.getZqfw(); // "上半年、全年"
        String zqlx = sjGfjsZsdwkhpjZb.getZqlx(); //  半年度
        String jb = sjGfjsZsdwkhpjZb.getJb(); //  直属单位
        Long parentid = sjGfjsZsdwkhpjZb.getParentDeptId(); //  上级单位*/


        return mxint;
    }

    public static void main(String[] args) {
        System.out.println(Double.parseDouble("-5"));
        System.out.println(Double.parseDouble("+5"));
    }


}
