package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.domain.JygxBmjj;
import com.qianhe.service.IJygxBmjjService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;

import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 经验共享-组织领导Controller
 *
 * @author qianhe
 * @date 2024-07-30
 */
@RestController
@RequestMapping("/system/bmjj")
public class JygxBmjjController extends BaseController
{
    @Autowired
    private IJygxBmjjService jygxBmjjService;

    /**
     * 查询经验共享-组织领导列表
     */
    @PreAuthorize("@ss.hasPermi('system:bmjj:list')")
    @GetMapping("/list")
    public TableDataInfo list(JygxBmjj jygxBmjj)
    {
        startPage();
        List<JygxBmjj> list = jygxBmjjService.selectJygxBmjjList(jygxBmjj);
        return getDataTable(list);
    }

    /**
     * 导出经验共享-组织领导列表
     */
    @PreAuthorize("@ss.hasPermi('system:bmjj:export')")
    @Log(title = "经验共享-组织领导", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, JygxBmjj jygxBmjj)
    {
        List<JygxBmjj> list = jygxBmjjService.selectJygxBmjjList(jygxBmjj);
        ExcelUtil<JygxBmjj> util = new ExcelUtil<JygxBmjj>(JygxBmjj.class);
        util.exportExcel(response, list, "经验共享-组织领导数据");
    }

    /**
     * 获取经验共享-组织领导详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:bmjj:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(jygxBmjjService.selectJygxBmjjById(id));
    }

    /**
     * 新增经验共享-组织领导
     */
    @PreAuthorize("@ss.hasPermi('system:bmjj:add')")
    @Log(title = "经验共享-组织领导", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody JygxBmjj jygxBmjj)
    {
        return toAjax(jygxBmjjService.insertJygxBmjj(jygxBmjj));
    }

    /**
     * 修改经验共享-组织领导
     */
    @PreAuthorize("@ss.hasPermi('system:bmjj:edit')")
    @Log(title = "经验共享-组织领导", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody JygxBmjj jygxBmjj)
    {
        return toAjax(jygxBmjjService.updateJygxBmjj(jygxBmjj));
    }

    /**
     * 删除经验共享-组织领导
     */
    @PreAuthorize("@ss.hasPermi('system:bmjj:remove')")
    @Log(title = "经验共享-组织领导", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(jygxBmjjService.deleteJygxBmjjByIds(ids));
    }
}
