package com.qianhe.service.impl;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.domain.SjGfjsZsdwkhpjZb;
import com.qianhe.mapper.SjGfjsZsdwkhpjZbMapper;
import com.qianhe.service.ISjGfjsJcdwkhpjZbService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 规范建设-基层单位考核评价主Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-24
 */
@Service
public class SjGfjsJcdwkhpjZbServiceImpl implements ISjGfjsJcdwkhpjZbService
{
    @Autowired
    private SjGfjsZsdwkhpjZbMapper sjGfjsZsdwkhpjZbMapper;

    /**
     * 查询规范建设-基层单位考核评价主
     *
     * @param id 规范建设-基层单位考核评价主主键
     * @return 规范建设-基层单位考核评价主
     */
    @Override
    public SjGfjsZsdwkhpjZb selectSjGfjsZsdwkhpjZbById(Long id)
    {
        return sjGfjsZsdwkhpjZbMapper.selectSjGfjsZsdwkhpjZbById(id);
    }

    /**
     * 查询规范建设-基层单位考核评价主列表
     *
     * @param sjGfjsZsdwkhpjZb 规范建设-基层单位考核评价主
     * @return 规范建设-基层单位考核评价主
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjGfjsZsdwkhpjZb> selectSjGfjsZsdwkhpjZbList(SjGfjsZsdwkhpjZb sjGfjsZsdwkhpjZb)
    {
        return sjGfjsZsdwkhpjZbMapper.selectSjGfjsZsdwkhpjZbList(sjGfjsZsdwkhpjZb);
    }

    /**
     * 新增规范建设-基层单位考核评价主
     *
     * @param sjGfjsZsdwkhpjZb 规范建设-基层单位考核评价主
     * @return 结果
     */
    @Override
    public int insertSjGfjsZsdwkhpjZb(SjGfjsZsdwkhpjZb sjGfjsZsdwkhpjZb)
    {
        sjGfjsZsdwkhpjZb.setCreateBy(SecurityUtils.getUsername());
        sjGfjsZsdwkhpjZb.setCreateTime(DateUtils.getNowDate());
        return sjGfjsZsdwkhpjZbMapper.insertSjGfjsZsdwkhpjZb(sjGfjsZsdwkhpjZb);
    }

    /**
     * 修改规范建设-基层单位考核评价主
     *
     * @param sjGfjsZsdwkhpjZb 规范建设-基层单位考核评价主
     * @return 结果
     */
    @Override
    public int updateSjGfjsZsdwkhpjZb(SjGfjsZsdwkhpjZb sjGfjsZsdwkhpjZb)
    {
        sjGfjsZsdwkhpjZb.setUpdateBy(SecurityUtils.getUsername());
        sjGfjsZsdwkhpjZb.setUpdateTime(DateUtils.getNowDate());
        return sjGfjsZsdwkhpjZbMapper.updateSjGfjsZsdwkhpjZb(sjGfjsZsdwkhpjZb);
    }

    /**
     * 批量删除规范建设-基层单位考核评价主
     *
     * @param ids 需要删除的规范建设-基层单位考核评价主主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsZsdwkhpjZbByIds(Long[] ids)
    {
        return sjGfjsZsdwkhpjZbMapper.deleteSjGfjsZsdwkhpjZbByIds(ids);
    }

    /**
     * 删除规范建设-基层单位考核评价主信息
     *
     * @param id 规范建设-基层单位考核评价主主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsZsdwkhpjZbById(Long id)
    {
        return sjGfjsZsdwkhpjZbMapper.deleteSjGfjsZsdwkhpjZbById(id);
    }

    @Override
    public SjGfjsZsdwkhpjZb selectSjGfjsZsdwkhpjZb(SjGfjsZsdwkhpjZb sjGfjsZsdwkhpjZb) {
        return sjGfjsZsdwkhpjZbMapper.selectSjGfjsZsdwkhpjZb(sjGfjsZsdwkhpjZb);
    }
}
