package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.common.core.domain.entity.SysRole;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.common.utils.StringUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.SjGfjsLbzdbf;
import com.qianhe.service.ISjGfjsLbzdbfService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 规范建设-练兵指导帮扶Controller
 *
 * @author qianhe
 * @date 2025-08-19
 */
@RestController
@RequestMapping("/system/SjGfjsLbzdbf")
public class SjGfjsLbzdbfController extends BaseController
{
    @Autowired
    private ISjGfjsLbzdbfService sjGfjsLbzdbfService;

    /**
     * 查询规范建设-练兵指导帮扶列表
     */

    @GetMapping("/list")
    public TableDataInfo list(SjGfjsLbzdbf sjGfjsLbzdbf)
    {
        sjGfjsLbzdbf.setLxr(SecurityUtils.getUserId());
        // 拿到角色如果是管理员 不限制。不是管理员只能看到自己的帮扶组
        List<SysRole> rolelist = SecurityUtils.getLoginUser().getUser().getRoles();
        if(StringUtils.isNotEmpty(rolelist)){
            for (SysRole role :rolelist){
                Long roleid = role.getRoleId();
                if(roleid==1||roleid==100){
                    sjGfjsLbzdbf.setLxr(null);
                }
            }
        }
        startPage();
        List<SjGfjsLbzdbf> list = sjGfjsLbzdbfService.selectSjGfjsLbzdbfList(sjGfjsLbzdbf);
        return getDataTable(list);
    }

    /**
     * 导出规范建设-练兵指导帮扶列表
     */

    @Log(title = "规范建设-练兵指导帮扶", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjGfjsLbzdbf sjGfjsLbzdbf)
    {
        List<SjGfjsLbzdbf> list = sjGfjsLbzdbfService.selectSjGfjsLbzdbfList(sjGfjsLbzdbf);
        ExcelUtil<SjGfjsLbzdbf> util = new ExcelUtil<SjGfjsLbzdbf>(SjGfjsLbzdbf.class);
        util.exportExcel(response, list, "规范建设-练兵指导帮扶数据");
    }

    /**
     * 获取规范建设-练兵指导帮扶详细信息
     */

    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjGfjsLbzdbfService.selectSjGfjsLbzdbfById(id));
    }

    /**
     * 新增规范建设-练兵指导帮扶
     */

    @Log(title = "规范建设-练兵指导帮扶", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjGfjsLbzdbf sjGfjsLbzdbf)
    {
        return toAjax(sjGfjsLbzdbfService.insertSjGfjsLbzdbf(sjGfjsLbzdbf));
    }

    /**
     * 修改规范建设-练兵指导帮扶
     */

    @Log(title = "规范建设-练兵指导帮扶", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjGfjsLbzdbf sjGfjsLbzdbf)
    {
        return toAjax(sjGfjsLbzdbfService.updateSjGfjsLbzdbf(sjGfjsLbzdbf));
    }

    /**
     * 删除规范建设-练兵指导帮扶
     */

    @Log(title = "规范建设-练兵指导帮扶", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjGfjsLbzdbfService.deleteSjGfjsLbzdbfByIds(ids));
    }
}
