package com.qianhe.system.service.impl;

import java.util.List;

import com.qianhe.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.qianhe.system.mapper.SysDeptCbMapper;
import com.qianhe.system.domain.SysDeptCb;
import com.qianhe.system.service.ISysDeptCbService;

/**
 * 单位从Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-10
 */
@Service
public class SysDeptCbServiceImpl implements ISysDeptCbService
{
    @Autowired
    private SysDeptCbMapper sysDeptCbMapper;

    /**
     * 查询单位从
     *
     * @param id 单位从主键
     * @return 单位从
     */
    @Override
    public SysDeptCb selectSysDeptCbById(Long id)
    {
        return sysDeptCbMapper.selectSysDeptCbById(id);
    }

    /**
     * 查询单位从列表
     *
     * @param sysDeptCb 单位从
     * @return 单位从
     */
    @Override
    public List<SysDeptCb> selectSysDeptCbList(SysDeptCb sysDeptCb)
    {
        return sysDeptCbMapper.selectSysDeptCbList(sysDeptCb);
    }

    /**
     * 新增单位从
     *
     * @param sysDeptCb 单位从
     * @return 结果
     */
    @Override
    public int insertSysDeptCb(SysDeptCb sysDeptCb)
    {
        //根据部门id 删除
        String nd = DateUtils.parseDateToStr("yyyy", DateUtils.getNowDate());
        sysDeptCbMapper.deleteSysDeptCbByDeptId(sysDeptCb.getDeptId(),nd);
        sysDeptCb.setNd(nd);
        return sysDeptCbMapper.insertSysDeptCb(sysDeptCb);
    }

    /**
     * 修改单位从
     *
     * @param sysDeptCb 单位从
     * @return 结果
     */
    @Override
    public int updateSysDeptCb(SysDeptCb sysDeptCb)
    {
        return sysDeptCbMapper.updateSysDeptCb(sysDeptCb);
    }

    /**
     * 批量删除单位从
     *
     * @param ids 需要删除的单位从主键
     * @return 结果
     */
    @Override
    public int deleteSysDeptCbByIds(Long[] ids)
    {
        return sysDeptCbMapper.deleteSysDeptCbByIds(ids);
    }

    /**
     * 删除单位从信息
     *
     * @param id 单位从主键
     * @return 结果
     */
    @Override
    public int deleteSysDeptCbById(Long id)
    {
        return sysDeptCbMapper.deleteSysDeptCbById(id);
    }

    @Override
    public SysDeptCb getInfoBydeptId(SysDeptCb sysDeptCb) {
        return sysDeptCbMapper.getInfoBydeptId(sysDeptCb);
    }
}
