package com.qianhe.service.impl;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.domain.SjGfjsZsdwkhpjZb;
import com.qianhe.domain.SjGfjsZsdwkhpjfjx;
import com.qianhe.mapper.SjGfjsZsdwkhpjZbMapper;
import com.qianhe.mapper.SjGfjsZsdwkhpjfjxMapper;
import com.qianhe.service.ISjGfjsZsdwkhpjfjxService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 规范建设-直属单位考核评价否决项Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-24
 */
@Service
public class SjGfjsZsdwkhpjfjxServiceImpl implements ISjGfjsZsdwkhpjfjxService
{
    @Autowired
    private SjGfjsZsdwkhpjfjxMapper sjGfjsZsdwkhpjfjxMapper;

    @Autowired
    private SjGfjsZsdwkhpjZbMapper sjGfjsZsdwkhpjZbMapper;
    /**
     * 查询规范建设-直属单位考核评价否决项
     *
     * @param id 规范建设-直属单位考核评价否决项主键
     * @return 规范建设-直属单位考核评价否决项
     */
    @Override
    public SjGfjsZsdwkhpjfjx selectSjGfjsZsdwkhpjfjxById(Long id)
    {
        return sjGfjsZsdwkhpjfjxMapper.selectSjGfjsZsdwkhpjfjxById(id);
    }

    /**
     * 查询规范建设-直属单位考核评价否决项列表
     *
     * @param sjGfjsZsdwkhpjfjx 规范建设-直属单位考核评价否决项
     * @return 规范建设-直属单位考核评价否决项
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjGfjsZsdwkhpjfjx> selectSjGfjsZsdwkhpjfjxList(SjGfjsZsdwkhpjfjx sjGfjsZsdwkhpjfjx)
    {
        return sjGfjsZsdwkhpjfjxMapper.selectSjGfjsZsdwkhpjfjxList(sjGfjsZsdwkhpjfjx);
    }

    /**
     * 新增规范建设-直属单位考核评价否决项
     *
     * @param sjGfjsZsdwkhpjfjx 规范建设-直属单位考核评价否决项
     * @return 结果
     */
    @Override
    public int insertSjGfjsZsdwkhpjfjx(SjGfjsZsdwkhpjfjx sjGfjsZsdwkhpjfjx)
    {
        sjGfjsZsdwkhpjfjx.setCreateTime(DateUtils.getNowDate());
        return sjGfjsZsdwkhpjfjxMapper.insertSjGfjsZsdwkhpjfjx(sjGfjsZsdwkhpjfjx);
    }

    /**
     * 修改规范建设-直属单位考核评价否决项
     *
     * @param sjGfjsZsdwkhpjfjx 规范建设-直属单位考核评价否决项
     * @return 结果
     */
    @Override
    public int updateSjGfjsZsdwkhpjfjx(SjGfjsZsdwkhpjfjx sjGfjsZsdwkhpjfjx)
    {
        sjGfjsZsdwkhpjfjx.setUpdateTime(DateUtils.getNowDate());
        return sjGfjsZsdwkhpjfjxMapper.updateSjGfjsZsdwkhpjfjx(sjGfjsZsdwkhpjfjx);
    }

    /**
     * 批量删除规范建设-直属单位考核评价否决项
     *
     * @param ids 需要删除的规范建设-直属单位考核评价否决项主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsZsdwkhpjfjxByIds(Long[] ids)
    {
        return sjGfjsZsdwkhpjfjxMapper.deleteSjGfjsZsdwkhpjfjxByIds(ids);
    }

    /**
     * 删除规范建设-直属单位考核评价否决项信息
     *
     * @param id 规范建设-直属单位考核评价否决项主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsZsdwkhpjfjxById(Long id)
    {
        return sjGfjsZsdwkhpjfjxMapper.deleteSjGfjsZsdwkhpjfjxById(id);
    }

    @Override
    public int batchSave(List<SjGfjsZsdwkhpjfjx> fjxList) {
        return sjGfjsZsdwkhpjfjxMapper.batchSave(fjxList);
    }

    @Override
    public int pledit(List<SjGfjsZsdwkhpjfjx> list) {
        SjGfjsZsdwkhpjfjx sjGfjsZsdwkhpjfjx = list.get(0);
        SjGfjsZsdwkhpjZb sjGfjsZsdwkhpjZb = sjGfjsZsdwkhpjZbMapper.selectSjGfjsZsdwkhpjZbById(sjGfjsZsdwkhpjfjx.getZbId());
        List<SjGfjsZsdwkhpjfjx> collect = list.stream().filter(item -> "是".equals(item.getSffs())).collect(Collectors.toList());
        sjGfjsZsdwkhpjZb.setSffjxs(new BigDecimal(collect.size()));
        sjGfjsZsdwkhpjZbMapper.updateSjGfjsZsdwkhpjZb(sjGfjsZsdwkhpjZb);
        return sjGfjsZsdwkhpjfjxMapper.pledit(list);
    }
}
