package com.qianhe.service.impl;

import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.domain.SjGfjsZdgz;
import com.qianhe.domain.SjGfjsZdgzCb;
import com.qianhe.mapper.SjGfjsZdgzMapper;
import com.qianhe.service.ISjGfjsZdgzService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * 规范建设-重点工作 原考核评价标准Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-22
 */
@Service
public class SjGfjsZdgzServiceImpl implements ISjGfjsZdgzService
{
    @Autowired
    private SjGfjsZdgzMapper sjGfjsZdgzMapper;

    /**
     * 查询规范建设-重点工作 原考核评价标准
     *
     * @param id 规范建设-重点工作 原考核评价标准主键
     * @return 规范建设-重点工作 原考核评价标准
     */
    @Override
    public SjGfjsZdgz selectSjGfjsZdgzById(Long id)
    {
        SjGfjsZdgz sjGfjsZdgz = sjGfjsZdgzMapper.selectSjGfjsZdgzById(id);
        List<SjGfjsZdgzCb> cbs=sjGfjsZdgzMapper.selectSjGfjsZdgzCbById(id);
        sjGfjsZdgz.setSjGfjsZdgzCbList(cbs);
        return sjGfjsZdgz;
    }

    /**
     * 查询规范建设-重点工作 原考核评价标准列表
     *
     * @param sjGfjsZdgz 规范建设-重点工作 原考核评价标准
     * @return 规范建设-重点工作 原考核评价标准
     */
    @Override
    public List<SjGfjsZdgz> selectSjGfjsZdgzList(SjGfjsZdgz sjGfjsZdgz)
    {
        return sjGfjsZdgzMapper.selectSjGfjsZdgzList(sjGfjsZdgz);
    }

    /**
     * 新增规范建设-重点工作 原考核评价标准
     *
     * @param sjGfjsZdgz 规范建设-重点工作 原考核评价标准
     * @return 结果
     */
    @Transactional
    @Override
    public int insertSjGfjsZdgz(SjGfjsZdgz sjGfjsZdgz)
    {
        sjGfjsZdgz.setCreateTime(DateUtils.getNowDate());
        sjGfjsZdgz.setCreateBy(SecurityUtils.getUsername());
        int rows = sjGfjsZdgzMapper.insertSjGfjsZdgz(sjGfjsZdgz);
        insertSjGfjsZdgzCb(sjGfjsZdgz);
        return rows;
    }

    /**
     * 修改规范建设-重点工作 原考核评价标准
     *
     * @param sjGfjsZdgz 规范建设-重点工作 原考核评价标准
     * @return 结果
     */
    @Transactional
    @Override
    public int updateSjGfjsZdgz(SjGfjsZdgz sjGfjsZdgz)
    {
        sjGfjsZdgz.setUpdateTime(DateUtils.getNowDate());
        sjGfjsZdgz.setUpdateBy(SecurityUtils.getUsername());
        sjGfjsZdgzMapper.deleteSjGfjsZdgzCbByZbId(sjGfjsZdgz.getId());
        insertSjGfjsZdgzCb(sjGfjsZdgz);
        return sjGfjsZdgzMapper.updateSjGfjsZdgz(sjGfjsZdgz);
    }

    /**
     * 批量删除规范建设-重点工作 原考核评价标准
     *
     * @param ids 需要删除的规范建设-重点工作 原考核评价标准主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSjGfjsZdgzByIds(Long[] ids)
    {
        sjGfjsZdgzMapper.deleteSjGfjsZdgzCbByZbIds(ids);
        return sjGfjsZdgzMapper.deleteSjGfjsZdgzByIds(ids);
    }

    /**
     * 删除规范建设-重点工作 原考核评价标准信息
     *
     * @param id 规范建设-重点工作 原考核评价标准主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSjGfjsZdgzById(Long id)
    {
        sjGfjsZdgzMapper.deleteSjGfjsZdgzCbByZbId(id);
        return sjGfjsZdgzMapper.deleteSjGfjsZdgzById(id);
    }

    @Override
    public List<SjGfjsZdgz> selectSjGfjsZdgzCxList(SjGfjsZdgz sjGfjsZdgz) {
        return sjGfjsZdgzMapper.selectSjGfjsZdgzCxList(sjGfjsZdgz);
    }

    @Override
    public List<String> getKhnrList(SjGfjsZdgzCb cb) {
        return sjGfjsZdgzMapper.getKhnrList(cb);
    }

    @Override
    public List<String> getKhxdList(SjGfjsZdgzCb cb) {
        return sjGfjsZdgzMapper.getKhxdList(cb);
    }

    @Override
    public List<SjGfjsZdgzCb> getPjbzList(SjGfjsZdgzCb cb) {
        return sjGfjsZdgzMapper.getPjbzList(cb);
    }

    /**
     * 新增规范建设-重点工作 原考核评价标准从信息
     *
     * @param sjGfjsZdgz 规范建设-重点工作 原考核评价标准对象
     */
    public void insertSjGfjsZdgzCb(SjGfjsZdgz sjGfjsZdgz)
    {
        List<SjGfjsZdgzCb> sjGfjsZdgzCbList = sjGfjsZdgz.getSjGfjsZdgzCbList();
        Long id = sjGfjsZdgz.getId();
        if (StringUtils.isNotNull(sjGfjsZdgzCbList))
        {
            List<SjGfjsZdgzCb> list = new ArrayList<SjGfjsZdgzCb>();
            for (int i=0;i<sjGfjsZdgzCbList.size();i++)
            {
                SjGfjsZdgzCb sjGfjsZdgzCb = sjGfjsZdgzCbList.get(i);
                sjGfjsZdgzCb.setCreateBy(SecurityUtils.getUsername());
                sjGfjsZdgzCb.setCreateTime(DateUtils.getNowDate());
                sjGfjsZdgzCb.setKhnr(sjGfjsZdgz.getKhnr());
                sjGfjsZdgzCb.setKhxd(sjGfjsZdgz.getKhxd());
                sjGfjsZdgzCb.setLx(sjGfjsZdgz.getLx());
                sjGfjsZdgzCb.setNd(sjGfjsZdgz.getNd());
                sjGfjsZdgzCb.setZbId(id);
                sjGfjsZdgzCb.setPx(i+1L);
                list.add(sjGfjsZdgzCb);
            }
            if (list.size() > 0)
            {
                sjGfjsZdgzMapper.batchSjGfjsZdgzCb(list);
            }
        }
    }

    @Transactional
    @Override
    public int updateSjGfjsZdgz_QZXS(SjGfjsZdgz sjGfjsZdgz)
    {
        return sjGfjsZdgzMapper.updateSjGfjsZdgz_QZXS(sjGfjsZdgz);
    }
}
