package com.qianhe.service.impl;

import java.util.Iterator;
import java.util.List;

import cn.hutool.core.codec.Base64;
import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.bean.BeanUtils;
import com.qianhe.domain.BzscCyglqglscCb;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.stream.Collectors;

import com.qianhe.common.utils.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import com.qianhe.domain.BzscSczhzxscCb;
import com.qianhe.mapper.BzscSczhzxscZbMapper;
import com.qianhe.domain.BzscSczhzxscZb;
import com.qianhe.service.IBzscSczhzxscZbService;

/**
 * 标准手册-生产指挥中心管理手册-主Service业务层处理
 *
 * @author qianhe
 * @date 2024-09-19
 */
@Service
public class BzscSczhzxscZbServiceImpl implements IBzscSczhzxscZbService
{
    @Autowired
    private BzscSczhzxscZbMapper bzscSczhzxscZbMapper;

    /**
     * 查询标准手册-生产指挥中心管理手册-主
     *
     * @param ID 标准手册-生产指挥中心管理手册-主主键
     * @return 标准手册-生产指挥中心管理手册-主
     */
    @Override
    public BzscSczhzxscZb selectBzscSczhzxscZbByID(Long ID)
    {
        BzscSczhzxscZb bzscSczhzxscZb = bzscSczhzxscZbMapper.selectBzscSczhzxscZbByID(ID);

        List<BzscSczhzxscCb> cbList=bzscSczhzxscZbMapper.selectBzscSczhzxscCbByID(ID);

        bzscSczhzxscZb.setBzscSczhzxscCbList( buildDeptTree(cbList));
        return bzscSczhzxscZb;
    }

    /**
     * 查询标准手册-生产指挥中心管理手册-主列表
     *
     * @param bzscSczhzxscZb 标准手册-生产指挥中心管理手册-主
     * @return 标准手册-生产指挥中心管理手册-主
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<BzscSczhzxscZb> selectBzscSczhzxscZbList(BzscSczhzxscZb bzscSczhzxscZb)
    {
        return bzscSczhzxscZbMapper.selectBzscSczhzxscZbList(bzscSczhzxscZb);
    }

    /**
     * 新增标准手册-生产指挥中心管理手册-主
     *
     * @param bzscSczhzxscZb 标准手册-生产指挥中心管理手册-主
     * @return 结果
     */
    @Transactional
    @Override
    public int insertBzscSczhzxscZb(BzscSczhzxscZb bzscSczhzxscZb)
    {
        bzscSczhzxscZb.setCreateTime(DateUtils.getNowDate());
        int rows = bzscSczhzxscZbMapper.insertBzscSczhzxscZb(bzscSczhzxscZb);
        insertBzscSczhzxscCb(bzscSczhzxscZb);
        return rows;
    }

    /**
     * 修改标准手册-生产指挥中心管理手册-主
     *
     * @param bzscSczhzxscZb 标准手册-生产指挥中心管理手册-主
     * @return 结果
     */
    @Transactional
    @Override
    public int updateBzscSczhzxscZb(BzscSczhzxscZb bzscSczhzxscZb)
    {
        bzscSczhzxscZb.setUpdateTime(DateUtils.getNowDate());
        bzscSczhzxscZbMapper.deleteBzscSczhzxscCbByZbId(bzscSczhzxscZb.getID());
        insertBzscSczhzxscCb(bzscSczhzxscZb);
        return bzscSczhzxscZbMapper.updateBzscSczhzxscZb(bzscSczhzxscZb);
    }

    /**
     * 批量删除标准手册-生产指挥中心管理手册-主
     *
     * @param IDs 需要删除的标准手册-生产指挥中心管理手册-主主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteBzscSczhzxscZbByIDs(Long[] IDs)
    {
        bzscSczhzxscZbMapper.deleteBzscSczhzxscCbByZbIds(IDs);
        return bzscSczhzxscZbMapper.deleteBzscSczhzxscZbByIDs(IDs);
    }

    /**
     * 删除标准手册-生产指挥中心管理手册-主信息
     *
     * @param ID 标准手册-生产指挥中心管理手册-主主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteBzscSczhzxscZbByID(Long ID)
    {
        bzscSczhzxscZbMapper.deleteBzscSczhzxscCbByZbId(ID);
        return bzscSczhzxscZbMapper.deleteBzscSczhzxscZbByID(ID);
    }

    /**
     * 新增标准手册-生产指挥中心管理手册-从信息
     *
     * @param bzscSczhzxscZb 标准手册-生产指挥中心管理手册-主对象
     */
    public void insertBzscSczhzxscCb(BzscSczhzxscZb bzscSczhzxscZb)
    {
        List<BzscSczhzxscCb> bzscSczhzxscCbList = bzscSczhzxscZb.getBzscSczhzxscCbList();
        Long ID = bzscSczhzxscZb.getID();
        if (StringUtils.isNotNull(bzscSczhzxscCbList))
        {
//            List<BzscSczhzxscCb> list = new ArrayList<BzscSczhzxscCb>();
            for (BzscSczhzxscCb bzscSczhzxscCb : bzscSczhzxscCbList)
            {
                bzscSczhzxscCb.setZbId(ID);
                bzscSczhzxscCb.setParentId(0L);
                bzscSczhzxscCb.setDeptId(bzscSczhzxscZb.getDeptId());
                bzscSczhzxscCb.setNd(bzscSczhzxscZb.getNd());
                bzscSczhzxscCb.setNr(new String(Base64.decode(bzscSczhzxscCb.getNr())));
                bzscSczhzxscZbMapper.insertBzscSczhzxscCb(bzscSczhzxscCb);
                if(StringUtils.isNotNull(bzscSczhzxscCb.getChildList())){
                    for(BzscSczhzxscCb cb1:bzscSczhzxscCb.getChildList()){
                        cb1.setZbId(ID);
                        cb1.setParentId(bzscSczhzxscCb.getID());
                        cb1.setDeptId(bzscSczhzxscZb.getDeptId());
                        cb1.setNd(bzscSczhzxscZb.getNd());
                        cb1.setNr(new String(Base64.decode(cb1.getNr())));
                        bzscSczhzxscZbMapper.insertBzscSczhzxscCb(cb1);
                        if(cb1.getChildList().size()>0){
                            for(BzscSczhzxscCb cb2:cb1.getChildList()){
                                cb2.setZbId(ID);
                                cb2.setParentId(cb1.getID());
                                cb2.setDeptId(bzscSczhzxscZb.getDeptId());
                                cb2.setNd(bzscSczhzxscZb.getNd());
                                cb2.setNr(new String(Base64.decode(cb2.getNr())));
                                bzscSczhzxscZbMapper.insertBzscSczhzxscCb(cb2);
                            }
                        }else {
                            //一级分类没有子级 则本身添加一条子级
                            BzscSczhzxscCb  cb2 =new BzscSczhzxscCb();
                            BeanUtils.copyProperties(cb1,cb2);
                            cb2.setZbId(ID);
                            cb2.setParentId(cb1.getID());
                            cb2.setDeptId(bzscSczhzxscZb.getDeptId());
                            cb2.setNd(bzscSczhzxscZb.getNd());
                            cb2.setNr(new String(Base64.decode(cb2.getNr())));
                            bzscSczhzxscZbMapper.insertBzscSczhzxscCb(cb2);
                        }
                    }
                }
//                list.add(bzscSczhzxscCb);
            }
//            if (list.size() > 0)
//            {
//                bzscSczhzxscZbMapper.batchBzscSczhzxscCb(list);
//            }
        }
    }


    public List<BzscSczhzxscCb> buildDeptTree(List<BzscSczhzxscCb> cbList)
    {
        List<BzscSczhzxscCb> returnList = new ArrayList<BzscSczhzxscCb>();
        List<Long> tempList = cbList.stream().map(BzscSczhzxscCb::getID).collect(Collectors.toList());
        for (BzscSczhzxscCb cb : cbList)
        {
            // 如果是顶级节点, 遍历该父节点的所有子节点
            if (!tempList.contains(cb.getParentId()))
            {
                recursionFn(cbList, cb);
                returnList.add(cb);
            }
        }
        if (returnList.isEmpty())
        {
            returnList = cbList;
        }
        return returnList;
    }

    /**
     * 递归列表
     */
    private void recursionFn(List<BzscSczhzxscCb> list, BzscSczhzxscCb t)
    {
        // 得到子节点列表
        List<BzscSczhzxscCb> childList = getChildList(list, t);
        t.setChildList(childList);
        for (BzscSczhzxscCb tChild : childList)
        {
            if (hasChild(list, tChild))
            {
                recursionFn(list, tChild);
            }
        }
    }

    /**
     * 得到子节点列表
     */
    private List<BzscSczhzxscCb> getChildList(List<BzscSczhzxscCb> list, BzscSczhzxscCb t)
    {
        List<BzscSczhzxscCb> tlist = new ArrayList<BzscSczhzxscCb>();
        Iterator<BzscSczhzxscCb> it = list.iterator();
        while (it.hasNext())
        {
            BzscSczhzxscCb n = (BzscSczhzxscCb) it.next();
            if (StringUtils.isNotNull(n.getParentId()) && n.getParentId().longValue() == t.getID().longValue())
            {
                tlist.add(n);
            }
        }
        return tlist;
    }

    /**
     * 判断是否有子节点
     */
    private boolean hasChild(List<BzscSczhzxscCb> list, BzscSczhzxscCb t)
    {
        return getChildList(list, t).size() > 0;
    }
}
