package com.qianhe.service;

import java.util.List;

import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.domain.SjFybp;
import com.qianhe.domain.Vo.SjfybpVo;

/**
 * 三基-费用报批Service接口
 * 
 * @author qianhe
 * @date 2024-07-05
 */
public interface ISjFybpService 
{
    /**
     * 查询三基-费用报批
     * 
     * @param id 三基-费用报批主键
     * @return 三基-费用报批
     */
    public SjFybp selectSjFybpById(Long id);

    /**
     * 查询三基-费用报批列表
     * 
     * @param sjFybp 三基-费用报批
     * @return 三基-费用报批集合
     */
    public List<SjFybp> selectSjFybpList(SjFybp sjFybp);

    /**
     * 新增三基-费用报批
     * 
     * @param sjFybp 三基-费用报批
     * @return 结果
     */
    public int insertSjFybp(SjFybp sjFybp);

    /**
     * 修改三基-费用报批
     * 
     * @param sjFybp 三基-费用报批
     * @return 结果
     */
    public int updateSjFybp(SjFybp sjFybp);

    /**
     * 批量删除三基-费用报批
     * 
     * @param ids 需要删除的三基-费用报批主键集合
     * @return 结果
     */
    public int deleteSjFybpByIds(Long[] ids);

    /**
     * 删除三基-费用报批信息
     * 
     * @param id 三基-费用报批主键
     * @return 结果
     */
    public int deleteSjFybpById(Long id);

    int tj(SjFybp sjFybp);

    int fywh(SjFybp sjFybp);

    List<SjfybpVo> tjtbByDept(SjFybp sjFybp);

    List<SjfybpVo> tjtbByfylx(SjFybp sjFybp);

    List<SjFybp> getFygz(SjFybp sjFybp);

    SjFybp getFygzById(Long id);

    List<SjFybp> selectSjFybpCtList(SjFybp sjFybp);
    List<SjfybpVo> zsdwNdfytj(SjFybp sjFybp);


}
