package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.SjGfjsLbzdbfJg;
import com.qianhe.service.ISjGfjsLbzdbfJgService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 规范建设-练兵指导帮扶结果Controller
 *
 * @author qianhe
 * @date 2025-08-19
 */
@RestController
@RequestMapping("/system/SjGfjsLbzdbfJg")
public class SjGfjsLbzdbfJgController extends BaseController
{
    @Autowired
    private ISjGfjsLbzdbfJgService sjGfjsLbzdbfJgService;

    /**
     * 查询规范建设-练兵指导帮扶结果列表
     */

    @GetMapping("/list")
    public TableDataInfo list(SjGfjsLbzdbfJg sjGfjsLbzdbfJg)
    {
        startPage();
        List<SjGfjsLbzdbfJg> list = sjGfjsLbzdbfJgService.selectSjGfjsLbzdbfJgList(sjGfjsLbzdbfJg);
        return getDataTable(list);
    }

    /**
     * 导出规范建设-练兵指导帮扶结果列表
     */

    @Log(title = "规范建设-练兵指导帮扶结果", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjGfjsLbzdbfJg sjGfjsLbzdbfJg)
    {
        List<SjGfjsLbzdbfJg> list = sjGfjsLbzdbfJgService.selectSjGfjsLbzdbfJgList(sjGfjsLbzdbfJg);
        ExcelUtil<SjGfjsLbzdbfJg> util = new ExcelUtil<SjGfjsLbzdbfJg>(SjGfjsLbzdbfJg.class);
        util.exportExcel(response, list, "规范建设-练兵指导帮扶结果数据");
    }

    /**
     * 获取规范建设-练兵指导帮扶结果详细信息
     */

    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjGfjsLbzdbfJgService.selectSjGfjsLbzdbfJgById(id));
    }

    /**
     * 新增规范建设-练兵指导帮扶结果
     */

    @Log(title = "规范建设-练兵指导帮扶结果", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjGfjsLbzdbfJg sjGfjsLbzdbfJg)
    {
        return toAjax(sjGfjsLbzdbfJgService.insertSjGfjsLbzdbfJg(sjGfjsLbzdbfJg));
    }

    /**
     * 修改规范建设-练兵指导帮扶结果
     */

    @Log(title = "规范建设-练兵指导帮扶结果", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjGfjsLbzdbfJg sjGfjsLbzdbfJg)
    {
        return toAjax(sjGfjsLbzdbfJgService.updateSjGfjsLbzdbfJg(sjGfjsLbzdbfJg));
    }

    /**
     * 删除规范建设-练兵指导帮扶结果
     */

    @Log(title = "规范建设-练兵指导帮扶结果", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjGfjsLbzdbfJgService.deleteSjGfjsLbzdbfJgByIds(ids));
    }
}
