package com.qianhe.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.domain.BzscCyglqglscCb;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.BzscCyglqglscZb;
import com.qianhe.service.IBzscCyglqglscZbService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 标准手册-采油管理区管理手册-主Controller
 *
 * @author qianhe
 * @date 2024-09-10
 */
@RestController
@RequestMapping("/system/bzscCyglqglscZb")
public class BzscCyglqglscZbController extends BaseController
{
    @Autowired
    private IBzscCyglqglscZbService bzscCyglqglscZbService;

    /**
     * 查询标准手册-采油管理区管理手册-主列表
     */
    @PreAuthorize("@ss.hasPermi('system:bzscCyglqglscZb:list')")
    @GetMapping("/list")
    public TableDataInfo list(BzscCyglqglscZb bzscCyglqglscZb)
    {
        startPage();
        List<BzscCyglqglscZb> list = bzscCyglqglscZbService.selectBzscCyglqglscZbList(bzscCyglqglscZb);
        return getDataTable(list);
    }

    /**
     * 导出标准手册-采油管理区管理手册-主列表
     */
    @PreAuthorize("@ss.hasPermi('system:bzscCyglqglscZb:export')")
    @Log(title = "标准手册-采油管理区管理手册-主", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BzscCyglqglscZb bzscCyglqglscZb)
    {
        List<BzscCyglqglscZb> list = bzscCyglqglscZbService.selectBzscCyglqglscZbList(bzscCyglqglscZb);
        ExcelUtil<BzscCyglqglscZb> util = new ExcelUtil<BzscCyglqglscZb>(BzscCyglqglscZb.class);
        util.exportExcel(response, list, "标准手册-采油管理区管理手册-主数据");
    }

    /**
     * 获取标准手册-采油管理区管理手册-主详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:bzscCyglqglscZb:query')")
    @GetMapping(value = "/{ID}")
    public AjaxResult getInfo(@PathVariable("ID") Long ID)
    {
        BzscCyglqglscZb bzscCyglqglscZb = bzscCyglqglscZbService.selectBzscCyglqglscZbByID(ID);
        Map<String,Object> map =new HashMap<>();
        BzscCyglqglscCb cb = bzscCyglqglscZb.getBzscCyglqglscCbList().size() > 0 ? bzscCyglqglscZb.getBzscCyglqglscCbList().get(0) : null;
        map.put("nr",cb!=null ?cb.getChildList():new ArrayList<BzscCyglqglscCb>());
        if(cb!=null){
            cb.setChildList(new ArrayList<>());
        }
        map.put("bt",cb);
        bzscCyglqglscZb.setBzscCyglqglscCbList(new ArrayList<>());
        map.put("bzscCyglqglscZb",bzscCyglqglscZb);
        return success(map);
    }

    /**
     * 新增标准手册-采油管理区管理手册-主
     */
    @PreAuthorize("@ss.hasPermi('system:bzscCyglqglscZb:add')")
    @Log(title = "标准手册-采油管理区管理手册-主", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BzscCyglqglscZb bzscCyglqglscZb)
    {
        return toAjax(bzscCyglqglscZbService.insertBzscCyglqglscZb(bzscCyglqglscZb));
    }

    /**
     * 修改标准手册-采油管理区管理手册-主
     */
    @PreAuthorize("@ss.hasPermi('system:bzscCyglqglscZb:edit')")
    @Log(title = "标准手册-采油管理区管理手册-主", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BzscCyglqglscZb bzscCyglqglscZb)
    {
        return toAjax(bzscCyglqglscZbService.updateBzscCyglqglscZb(bzscCyglqglscZb));
    }

    /**
     * 删除标准手册-采油管理区管理手册-主
     */
    @PreAuthorize("@ss.hasPermi('system:bzscCyglqglscZb:remove')")
    @Log(title = "标准手册-采油管理区管理手册-主", businessType = BusinessType.DELETE)
	@DeleteMapping("/{IDs}")
    public AjaxResult remove(@PathVariable Long[] IDs)
    {
        return toAjax(bzscCyglqglscZbService.deleteBzscCyglqglscZbByIDs(IDs));
    }



}
