package com.qianhe.system.service;

import java.util.List;
import com.qianhe.system.domain.SysDeptCb;

/**
 * 单位从Service接口
 * 
 * @author qianhe
 * @date 2024-07-10
 */
public interface ISysDeptCbService 
{
    /**
     * 查询单位从
     * 
     * @param id 单位从主键
     * @return 单位从
     */
    public SysDeptCb selectSysDeptCbById(Long id);

    /**
     * 查询单位从列表
     * 
     * @param sysDeptCb 单位从
     * @return 单位从集合
     */
    public List<SysDeptCb> selectSysDeptCbList(SysDeptCb sysDeptCb);

    /**
     * 新增单位从
     * 
     * @param sysDeptCb 单位从
     * @return 结果
     */
    public int insertSysDeptCb(SysDeptCb sysDeptCb);

    /**
     * 修改单位从
     * 
     * @param sysDeptCb 单位从
     * @return 结果
     */
    public int updateSysDeptCb(SysDeptCb sysDeptCb);

    /**
     * 批量删除单位从
     * 
     * @param ids 需要删除的单位从主键集合
     * @return 结果
     */
    public int deleteSysDeptCbByIds(Long[] ids);

    /**
     * 删除单位从信息
     * 
     * @param id 单位从主键
     * @return 结果
     */
    public int deleteSysDeptCbById(Long id);

    SysDeptCb getInfoBydeptId(SysDeptCb sysDeptCb);


}
