package com.qianhe.system.mapper;

import java.util.List;
import com.qianhe.system.domain.SysDeptCb;
import org.apache.ibatis.annotations.Param;

/**
 * 单位从Mapper接口
 * 
 * @author qianhe
 * @date 2024-07-10
 */
public interface SysDeptCbMapper 
{
    /**
     * 查询单位从
     * 
     * @param id 单位从主键
     * @return 单位从
     */
    public SysDeptCb selectSysDeptCbById(Long id);

    /**
     * 查询单位从列表
     * 
     * @param sysDeptCb 单位从
     * @return 单位从集合
     */
    public List<SysDeptCb> selectSysDeptCbList(SysDeptCb sysDeptCb);

    /**
     * 新增单位从
     * 
     * @param sysDeptCb 单位从
     * @return 结果
     */
    public int insertSysDeptCb(SysDeptCb sysDeptCb);

    /**
     * 修改单位从
     * 
     * @param sysDeptCb 单位从
     * @return 结果
     */
    public int updateSysDeptCb(SysDeptCb sysDeptCb);

    /**
     * 删除单位从
     * 
     * @param id 单位从主键
     * @return 结果
     */
    public int deleteSysDeptCbById(Long id);

    /**
     * 批量删除单位从
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSysDeptCbByIds(Long[] ids);

    SysDeptCb getInfoBydeptId(SysDeptCb sysDeptCb);


    int deleteSysDeptCbByDeptId(@Param("deptId") String deptId, @Param("nd")String nd);

}
