package com.qianhe.web.controller.system;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.system.domain.SysDeptFl;
import com.qianhe.system.service.ISysDeptFlService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;

import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 单位分类Controller
 *
 * @author qianhe
 * @date 2024-07-22
 */
@RestController
@RequestMapping("/system/sysDeptFl")
public class SysDeptFlController extends BaseController
{
    @Autowired
    private ISysDeptFlService sysDeptFlService;

    /**
     * 查询单位分类列表
     */
//    @PreAuthorize("@ss.hasPermi('system:sysDeptFl:list')")
    @GetMapping("/list")
    public TableDataInfo list(SysDeptFl sysDeptFl)
    {
//        startPage();
        List<SysDeptFl> list = sysDeptFlService.selectSysDeptFlList(sysDeptFl);
        return getDataTable(list);
    }

    /**
     * 导出单位分类列表
     */
    @PreAuthorize("@ss.hasPermi('system:sysDeptFl:export')")
    @Log(title = "单位分类", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SysDeptFl sysDeptFl)
    {
        List<SysDeptFl> list = sysDeptFlService.selectSysDeptFlList(sysDeptFl);
        ExcelUtil<SysDeptFl> util = new ExcelUtil<SysDeptFl>(SysDeptFl.class);
        util.exportExcel(response, list, "单位分类数据");
    }

    /**
     * 获取单位分类详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:sysDeptFl:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sysDeptFlService.selectSysDeptFlById(id));
    }

    /**
     * 新增单位分类
     */
    @PreAuthorize("@ss.hasPermi('system:sysDeptFl:add')")
    @Log(title = "单位分类", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysDeptFl sysDeptFl)
    {
        return toAjax(sysDeptFlService.insertSysDeptFl(sysDeptFl));
    }

    /**
     * 修改单位分类
     */
    @PreAuthorize("@ss.hasPermi('system:sysDeptFl:edit')")
    @Log(title = "单位分类", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysDeptFl sysDeptFl)
    {
        return toAjax(sysDeptFlService.updateSysDeptFl(sysDeptFl));
    }

    /**
     * 删除单位分类
     */
    @PreAuthorize("@ss.hasPermi('system:sysDeptFl:remove')")
    @Log(title = "单位分类", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sysDeptFlService.deleteSysDeptFlByIds(ids));
    }
}
