package com.qianhe.web.controller.system;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.system.domain.SysDeptCb;
import com.qianhe.system.service.ISysDeptCbService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 单位从Controller
 *
 * @author qianhe
 * @date 2024-07-10
 */
@RestController
@RequestMapping("/system/sysDeptCb")
public class SysDeptCbController extends BaseController
{
    @Autowired
    private ISysDeptCbService sysDeptCbService;

    /**
     * 查询单位从列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SysDeptCb sysDeptCb)
    {
        startPage();
        List<SysDeptCb> list = sysDeptCbService.selectSysDeptCbList(sysDeptCb);
        return getDataTable(list);
    }

    /**
     * 导出单位从列表
     */
    @Log(title = "单位从", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SysDeptCb sysDeptCb)
    {
        List<SysDeptCb> list = sysDeptCbService.selectSysDeptCbList(sysDeptCb);
        ExcelUtil<SysDeptCb> util = new ExcelUtil<SysDeptCb>(SysDeptCb.class);
        util.exportExcel(response, list, "单位从数据");
    }

    /**
     * 获取单位从详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sysDeptCbService.selectSysDeptCbById(id));
    }

    /**
     * 新增单位从
     */
    @Log(title = "单位从", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysDeptCb sysDeptCb)
    {
        return toAjax(sysDeptCbService.insertSysDeptCb(sysDeptCb));
    }

    /**
     * 修改单位从
     */
    @Log(title = "单位从", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysDeptCb sysDeptCb)
    {
        return toAjax(sysDeptCbService.updateSysDeptCb(sysDeptCb));
    }

    /**
     * 删除单位从
     */
    @Log(title = "单位从", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sysDeptCbService.deleteSysDeptCbByIds(ids));
    }



    /**
     * 获取单位从详细信息
     */
    @GetMapping(value = "/getInfoBydeptId")
    public AjaxResult getInfoBydeptId(SysDeptCb sysDeptCb)
    {

        return success(sysDeptCbService.getInfoBydeptId(sysDeptCb));
    }


}
