package com.ruoyi.project.ys.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.ys.mapper.YsqqXmxxSegyMapper;
import com.ruoyi.project.ys.domain.YsqqXmxxSegy;
import com.ruoyi.project.ys.service.IYsqqXmxxSegyService;

/**
 * segy信息Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@Service
public class YsqqXmxxSegyServiceImpl implements IYsqqXmxxSegyService 
{
    @Autowired
    private YsqqXmxxSegyMapper ysqqXmxxSegyMapper;

    /**
     * 查询segy信息
     * 
     * @param id segy信息主键
     * @return segy信息
     */
    @Override
    public YsqqXmxxSegy selectYsqqXmxxSegyById(Long id)
    {
        return ysqqXmxxSegyMapper.selectYsqqXmxxSegyById(id);
    }

    /**
     * 查询segy信息列表
     * 
     * @param ysqqXmxxSegy segy信息
     * @return segy信息
     */
    @Override
    public List<YsqqXmxxSegy> selectYsqqXmxxSegyList(YsqqXmxxSegy ysqqXmxxSegy)
    {
        return ysqqXmxxSegyMapper.selectYsqqXmxxSegyList(ysqqXmxxSegy);
    }

    /**
     * 新增segy信息
     * 
     * @param ysqqXmxxSegy segy信息
     * @return 结果
     */
    @Override
    public int insertYsqqXmxxSegy(YsqqXmxxSegy ysqqXmxxSegy)
    {
        return ysqqXmxxSegyMapper.insertYsqqXmxxSegy(ysqqXmxxSegy);
    }

    /**
     * 修改segy信息
     * 
     * @param ysqqXmxxSegy segy信息
     * @return 结果
     */
    @Override
    public int updateYsqqXmxxSegy(YsqqXmxxSegy ysqqXmxxSegy)
    {
        ysqqXmxxSegy.setUpdateTime(DateUtils.getNowDate());
        return ysqqXmxxSegyMapper.updateYsqqXmxxSegy(ysqqXmxxSegy);
    }

    /**
     * 批量删除segy信息
     * 
     * @param ids 需要删除的segy信息主键
     * @return 结果
     */
    @Override
    public int deleteYsqqXmxxSegyByIds(Long[] ids)
    {
        return ysqqXmxxSegyMapper.deleteYsqqXmxxSegyByIds(ids);
    }

    /**
     * 删除segy信息信息
     * 
     * @param id segy信息主键
     * @return 结果
     */
    @Override
    public int deleteYsqqXmxxSegyById(Long id)
    {
        return ysqqXmxxSegyMapper.deleteYsqqXmxxSegyById(id);
    }
}
