package com.ruoyi.project.ys.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.ys.mapper.HyjyxxMapper;
import com.ruoyi.project.ys.domain.Hyjyxx;
import com.ruoyi.project.ys.service.IHyjyxxService;

/**
 * 会议信息Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@Service
public class HyjyxxServiceImpl implements IHyjyxxService 
{
    @Autowired
    private HyjyxxMapper hyjyxxMapper;

    /**
     * 查询会议信息
     * 
     * @param id 会议信息主键
     * @return 会议信息
     */
    @Override
    public Hyjyxx selectHyjyxxById(Long id)
    {
        return hyjyxxMapper.selectHyjyxxById(id);
    }

    /**
     * 查询会议信息列表
     * 
     * @param hyjyxx 会议信息
     * @return 会议信息
     */
    @Override
    public List<Hyjyxx> selectHyjyxxList(Hyjyxx hyjyxx)
    {
        return hyjyxxMapper.selectHyjyxxList(hyjyxx);
    }

    /**
     * 新增会议信息
     * 
     * @param hyjyxx 会议信息
     * @return 结果
     */
    @Override
    public int insertHyjyxx(Hyjyxx hyjyxx)
    {
        return hyjyxxMapper.insertHyjyxx(hyjyxx);
    }

    /**
     * 修改会议信息
     * 
     * @param hyjyxx 会议信息
     * @return 结果
     */
    @Override
    public int updateHyjyxx(Hyjyxx hyjyxx)
    {
        hyjyxx.setUpdateTime(DateUtils.getNowDate());
        return hyjyxxMapper.updateHyjyxx(hyjyxx);
    }

    /**
     * 批量删除会议信息
     * 
     * @param ids 需要删除的会议信息主键
     * @return 结果
     */
    @Override
    public int deleteHyjyxxByIds(Long[] ids)
    {
        return hyjyxxMapper.deleteHyjyxxByIds(ids);
    }

    /**
     * 删除会议信息信息
     * 
     * @param id 会议信息主键
     * @return 结果
     */
    @Override
    public int deleteHyjyxxById(Long id)
    {
        return hyjyxxMapper.deleteHyjyxxById(id);
    }
}
