package com.ruoyi.project.ys.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.ys.domain.YsqqXmxx;
import com.ruoyi.project.ys.service.IYsqqXmxxService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 验收前期-项目信息Controller
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@RestController
@RequestMapping("/ysqqXmxx/ysqqXmxx")
public class YsqqXmxxController extends BaseController
{
    @Autowired
    private IYsqqXmxxService ysqqXmxxService;

    /**
     * 查询验收前期-项目信息列表
     */
    @PreAuthorize("@ss.hasPermi('ysqqXmxx:ysqqXmxx:list')")
    @GetMapping("/list")
    public TableDataInfo list(YsqqXmxx ysqqXmxx)
    {
        startPage();
        List<YsqqXmxx> list = ysqqXmxxService.selectYsqqXmxxList(ysqqXmxx);
        return getDataTable(list);
    }

    /**
     * 导出验收前期-项目信息列表
     */
    @PreAuthorize("@ss.hasPermi('ysqqXmxx:ysqqXmxx:export')")
    @Log(title = "验收前期-项目信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, YsqqXmxx ysqqXmxx)
    {
        List<YsqqXmxx> list = ysqqXmxxService.selectYsqqXmxxList(ysqqXmxx);
        ExcelUtil<YsqqXmxx> util = new ExcelUtil<YsqqXmxx>(YsqqXmxx.class);
        util.exportExcel(response, list, "验收前期-项目信息数据");
    }

    /**
     * 获取验收前期-项目信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('ysqqXmxx:ysqqXmxx:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(ysqqXmxxService.selectYsqqXmxxById(id));
    }

    /**
     * 新增验收前期-项目信息
     */
    @PreAuthorize("@ss.hasPermi('ysqqXmxx:ysqqXmxx:add')")
    @Log(title = "验收前期-项目信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody YsqqXmxx ysqqXmxx)
    {
        return toAjax(ysqqXmxxService.insertYsqqXmxx(ysqqXmxx));
    }

    /**
     * 修改验收前期-项目信息
     */
    @PreAuthorize("@ss.hasPermi('ysqqXmxx:ysqqXmxx:edit')")
    @Log(title = "验收前期-项目信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody YsqqXmxx ysqqXmxx)
    {
        return toAjax(ysqqXmxxService.updateYsqqXmxx(ysqqXmxx));
    }

    /**
     * 删除验收前期-项目信息
     */
    @PreAuthorize("@ss.hasPermi('ysqqXmxx:ysqqXmxx:remove')")
    @Log(title = "验收前期-项目信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(ysqqXmxxService.deleteYsqqXmxxByIds(ids));
    }
}
