package com.ruoyi.project.ys.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.ys.domain.HyjyxxMb;
import com.ruoyi.project.ys.service.IHyjyxxMbService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 会议模板Controller
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@RestController
@RequestMapping("/hyjyxxMb/hymb")
public class HyjyxxMbController extends BaseController
{
    @Autowired
    private IHyjyxxMbService hyjyxxMbService;

    /**
     * 查询会议模板列表
     */
    @PreAuthorize("@ss.hasPermi('hyjyxxMb:hymb:list')")
    @GetMapping("/list")
    public TableDataInfo list(HyjyxxMb hyjyxxMb)
    {
        startPage();
        List<HyjyxxMb> list = hyjyxxMbService.selectHyjyxxMbList(hyjyxxMb);
        return getDataTable(list);
    }

    /**
     * 导出会议模板列表
     */
    @PreAuthorize("@ss.hasPermi('hyjyxxMb:hymb:export')")
    @Log(title = "会议模板", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, HyjyxxMb hyjyxxMb)
    {
        List<HyjyxxMb> list = hyjyxxMbService.selectHyjyxxMbList(hyjyxxMb);
        ExcelUtil<HyjyxxMb> util = new ExcelUtil<HyjyxxMb>(HyjyxxMb.class);
        util.exportExcel(response, list, "会议模板数据");
    }

    /**
     * 获取会议模板详细信息
     */
    @PreAuthorize("@ss.hasPermi('hyjyxxMb:hymb:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(hyjyxxMbService.selectHyjyxxMbById(id));
    }

    /**
     * 新增会议模板
     */
    @PreAuthorize("@ss.hasPermi('hyjyxxMb:hymb:add')")
    @Log(title = "会议模板", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody HyjyxxMb hyjyxxMb)
    {
        return toAjax(hyjyxxMbService.insertHyjyxxMb(hyjyxxMb));
    }

    /**
     * 修改会议模板
     */
    @PreAuthorize("@ss.hasPermi('hyjyxxMb:hymb:edit')")
    @Log(title = "会议模板", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody HyjyxxMb hyjyxxMb)
    {
        return toAjax(hyjyxxMbService.updateHyjyxxMb(hyjyxxMb));
    }

    /**
     * 删除会议模板
     */
    @PreAuthorize("@ss.hasPermi('hyjyxxMb:hymb:remove')")
    @Log(title = "会议模板", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(hyjyxxMbService.deleteHyjyxxMbByIds(ids));
    }
}
