package com.ruoyi.project.ys.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.ys.mapper.HyjyxxFileMapper;
import com.ruoyi.project.ys.domain.HyjyxxFile;
import com.ruoyi.project.ys.service.IHyjyxxFileService;

/**
 * 会议纪要_附件Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-11-03
 */
@Service
public class HyjyxxFileServiceImpl implements IHyjyxxFileService 
{
    @Autowired
    private HyjyxxFileMapper hyjyxxFileMapper;

    /**
     * 查询会议纪要_附件
     * 
     * @param id 会议纪要_附件主键
     * @return 会议纪要_附件
     */
    @Override
    public HyjyxxFile selectHyjyxxFileById(Long id)
    {
        return hyjyxxFileMapper.selectHyjyxxFileById(id);
    }

    /**
     * 查询会议纪要_附件列表
     * 
     * @param hyjyxxFile 会议纪要_附件
     * @return 会议纪要_附件
     */
    @Override
    public List<HyjyxxFile> selectHyjyxxFileList(HyjyxxFile hyjyxxFile)
    {
        return hyjyxxFileMapper.selectHyjyxxFileList(hyjyxxFile);
    }

    /**
     * 新增会议纪要_附件
     * 
     * @param hyjyxxFile 会议纪要_附件
     * @return 结果
     */
    @Override
    public int insertHyjyxxFile(HyjyxxFile hyjyxxFile)
    {
        return hyjyxxFileMapper.insertHyjyxxFile(hyjyxxFile);
    }

    /**
     * 修改会议纪要_附件
     * 
     * @param hyjyxxFile 会议纪要_附件
     * @return 结果
     */
    @Override
    public int updateHyjyxxFile(HyjyxxFile hyjyxxFile)
    {
        hyjyxxFile.setUpdateTime(DateUtils.getNowDate());
        return hyjyxxFileMapper.updateHyjyxxFile(hyjyxxFile);
    }

    /**
     * 批量删除会议纪要_附件
     * 
     * @param ids 需要删除的会议纪要_附件主键
     * @return 结果
     */
    @Override
    public int deleteHyjyxxFileByIds(Long[] ids)
    {
        return hyjyxxFileMapper.deleteHyjyxxFileByIds(ids);
    }

    /**
     * 删除会议纪要_附件信息
     * 
     * @param id 会议纪要_附件主键
     * @return 结果
     */
    @Override
    public int deleteHyjyxxFileById(Long id)
    {
        return hyjyxxFileMapper.deleteHyjyxxFileById(id);
    }
}
