package com.ruoyi.project.ys.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.ys.domain.YsqqXmxxXmcy;
import com.ruoyi.project.ys.service.IYsqqXmxxXmcyService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 验收前期-项目信息-项目成员Controller
 * 
 * @author ruoyi
 * @date 2025-10-30
 */
@RestController
@RequestMapping("/ysqqXmxxXmcy/xmcy")
public class YsqqXmxxXmcyController extends BaseController
{
    @Autowired
    private IYsqqXmxxXmcyService ysqqXmxxXmcyService;

    /**
     * 查询验收前期-项目信息-项目成员列表
     */
    @GetMapping("/list")
    public TableDataInfo list(YsqqXmxxXmcy ysqqXmxxXmcy)
    {
        startPage();
        List<YsqqXmxxXmcy> list = ysqqXmxxXmcyService.selectYsqqXmxxXmcyList(ysqqXmxxXmcy);
        return getDataTable(list);
    }

    /**
     * 导出验收前期-项目信息-项目成员列表
     */
    @PreAuthorize("@ss.hasPermi('ysqqXmxxXmcy:xmcy:export')")
    @Log(title = "验收前期-项目信息-项目成员", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, YsqqXmxxXmcy ysqqXmxxXmcy)
    {
        List<YsqqXmxxXmcy> list = ysqqXmxxXmcyService.selectYsqqXmxxXmcyList(ysqqXmxxXmcy);
        ExcelUtil<YsqqXmxxXmcy> util = new ExcelUtil<YsqqXmxxXmcy>(YsqqXmxxXmcy.class);
        util.exportExcel(response, list, "验收前期-项目信息-项目成员数据");
    }

    /**
     * 获取验收前期-项目信息-项目成员详细信息
     */
    @GetMapping(value = "/{cyid}")
    public AjaxResult getInfo(@PathVariable("cyid") Long cyid)
    {
        return success(ysqqXmxxXmcyService.selectYsqqXmxxXmcyByCyid(cyid));
    }

    /**
     * 新增验收前期-项目信息-项目成员
     */
    @Log(title = "验收前期-项目信息-项目成员", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody YsqqXmxxXmcy ysqqXmxxXmcy)
    {
        return toAjax(ysqqXmxxXmcyService.insertYsqqXmxxXmcy(ysqqXmxxXmcy));
    }

    /**
     * 修改验收前期-项目信息-项目成员
     */
    @Log(title = "验收前期-项目信息-项目成员", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody YsqqXmxxXmcy ysqqXmxxXmcy)
    {
        return toAjax(ysqqXmxxXmcyService.updateYsqqXmxxXmcy(ysqqXmxxXmcy));
    }

    /**
     * 删除验收前期-项目信息-项目成员
     */
    @Log(title = "验收前期-项目信息-项目成员", businessType = BusinessType.DELETE)
	@DeleteMapping("/{cyids}")
    public AjaxResult remove(@PathVariable Long[] cyids)
    {
        return toAjax(ysqqXmxxXmcyService.deleteYsqqXmxxXmcyByCyids(cyids));
    }
}
