package com.ruoyi.project.ys.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.ys.domain.YscgFileRole;
import com.ruoyi.project.ys.service.IYscgFileRoleService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 成果单文件权限管理Controller
 * 
 * @author ruoyi
 * @date 2025-10-31
 */
@RestController
@RequestMapping("/yscgFileRole/filerole")
public class YscgFileRoleController extends BaseController
{
    @Autowired
    private IYscgFileRoleService yscgFileRoleService;

    /**
     * 查询成果单文件权限管理列表
     */
    @GetMapping("/list")
    public TableDataInfo list(YscgFileRole yscgFileRole)
    {
        startPage();
        List<YscgFileRole> list = yscgFileRoleService.selectYscgFileRoleList(yscgFileRole);
        return getDataTable(list);
    }

    /**
     * 导出成果单文件权限管理列表
     */
    @Log(title = "成果单文件权限管理", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, YscgFileRole yscgFileRole)
    {
        List<YscgFileRole> list = yscgFileRoleService.selectYscgFileRoleList(yscgFileRole);
        ExcelUtil<YscgFileRole> util = new ExcelUtil<YscgFileRole>(YscgFileRole.class);
        util.exportExcel(response, list, "成果单文件权限管理数据");
    }

    /**
     * 获取成果单文件权限管理详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(yscgFileRoleService.selectYscgFileRoleById(id));
    }

    /**
     * 新增成果单文件权限管理
     */
    @Log(title = "成果单文件权限管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody YscgFileRole yscgFileRole)
    {
        return toAjax(yscgFileRoleService.insertYscgFileRole(yscgFileRole));
    }

    /**
     * 修改成果单文件权限管理
     */
    @Log(title = "成果单文件权限管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody YscgFileRole yscgFileRole)
    {
        return toAjax(yscgFileRoleService.updateYscgFileRole(yscgFileRole));
    }

    /**
     * 删除成果单文件权限管理
     */
    @Log(title = "成果单文件权限管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(yscgFileRoleService.deleteYscgFileRoleByIds(ids));
    }

    @PutMapping("/batchYscgFileRole")
    public AjaxResult batchYscgFileRole(Long fileid, Long[] userIds)
    {
        return toAjax(yscgFileRoleService.batchYscgFileRole(fileid, userIds));
    }
}
