package com.ruoyi.project.ys.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.ys.mapper.CommunFileMapper;
import com.ruoyi.project.ys.domain.CommunFile;
import com.ruoyi.project.ys.service.ICommunFileService;

/**
 * 公用附件表Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@Service
public class CommunFileServiceImpl implements ICommunFileService 
{
    @Autowired
    private CommunFileMapper communFileMapper;

    /**
     * 查询公用附件表
     * 
     * @param ID 公用附件表主键
     * @return 公用附件表
     */
    @Override
    public CommunFile selectCommunFileByID(Long ID)
    {
        return communFileMapper.selectCommunFileByID(ID);
    }

    /**
     * 查询公用附件表列表
     * 
     * @param communFile 公用附件表
     * @return 公用附件表
     */
    @Override
    public List<CommunFile> selectCommunFileList(CommunFile communFile)
    {
        return communFileMapper.selectCommunFileList(communFile);
    }

    /**
     * 新增公用附件表
     * 
     * @param communFile 公用附件表
     * @return 结果
     */
    @Override
    public int insertCommunFile(CommunFile communFile)
    {
        return communFileMapper.insertCommunFile(communFile);
    }

    /**
     * 修改公用附件表
     * 
     * @param communFile 公用附件表
     * @return 结果
     */
    @Override
    public int updateCommunFile(CommunFile communFile)
    {
        communFile.setUpdateTime(DateUtils.getNowDate());
        return communFileMapper.updateCommunFile(communFile);
    }

    /**
     * 批量删除公用附件表
     * 
     * @param IDs 需要删除的公用附件表主键
     * @return 结果
     */
    @Override
    public int deleteCommunFileByIDs(Long[] IDs)
    {
        return communFileMapper.deleteCommunFileByIDs(IDs);
    }

    /**
     * 删除公用附件表信息
     * 
     * @param ID 公用附件表主键
     * @return 结果
     */
    @Override
    public int deleteCommunFileByID(Long ID)
    {
        return communFileMapper.deleteCommunFileByID(ID);
    }
}
