package com.ruoyi.project.ys.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * segy信息对象 ysqq_xmxx_segy
 *
 * @author ruoyi
 * @date 2025-09-18
 */
public class YsqqXmxxSegy extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 主表id */
    @Excel(name = "主表id")
    private Long zbid;

    /** 旧版segy路径 */
    @Excel(name = "旧版segy路径")
    private String jbsegy;

    /** 新版segy路径 */
    @Excel(name = "新版segy路径")
    private String xbsegy;

    /** x轴坐标 */
    @Excel(name = "x轴坐标")
    private String x;

    /** y轴坐标 */
    @Excel(name = "y轴坐标")
    private String y;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    /** 备用1 */
    @Excel(name = "备用1")
    private String ext1;

    /** 备用2 */
    @Excel(name = "备用2")
    private String ext2;

    /** 备用3 */
    @Excel(name = "备用3")
    private String ext3;

    /** 旧版segy名称 */
    @Excel(name = "旧版segy名称")
    private String jbsegyName;

    /** 新版segy名称 */
    @Excel(name = "新版segy名称")
    private String xbsegyName;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }

    public void setZbid(Long zbid)
    {
        this.zbid = zbid;
    }

    public Long getZbid()
    {
        return zbid;
    }

    public void setJbsegy(String jbsegy)
    {
        this.jbsegy = jbsegy;
    }

    public String getJbsegy()
    {
        return jbsegy;
    }

    public void setXbsegy(String xbsegy)
    {
        this.xbsegy = xbsegy;
    }

    public String getXbsegy()
    {
        return xbsegy;
    }

    public void setX(String x)
    {
        this.x = x;
    }

    public String getX()
    {
        return x;
    }

    public void setY(String y)
    {
        this.y = y;
    }

    public String getY()
    {
        return y;
    }

    public void setCreatedBy(String createdBy)
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy()
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime)
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime()
    {
        return createdTime;
    }

    public void setExt1(String ext1)
    {
        this.ext1 = ext1;
    }

    public String getExt1()
    {
        return ext1;
    }

    public void setExt2(String ext2)
    {
        this.ext2 = ext2;
    }

    public String getExt2()
    {
        return ext2;
    }

    public void setExt3(String ext3)
    {
        this.ext3 = ext3;
    }

    public String getExt3()
    {
        return ext3;
    }

    public void setJbsegyName(String jbsegyName)
    {
        this.jbsegyName = jbsegyName;
    }

    public String getJbsegyName()
    {
        return jbsegyName;
    }

    public void setXbsegyName(String xbsegyName)
    {
        this.xbsegyName = xbsegyName;
    }

    public String getXbsegyName()
    {
        return xbsegyName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("zbid", getZbid())
                .append("jbsegy", getJbsegy())
                .append("xbsegy", getXbsegy())
                .append("x", getX())
                .append("y", getY())
                .append("createdBy", getCreatedBy())
                .append("createdTime", getCreatedTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .append("ext1", getExt1())
                .append("ext2", getExt2())
                .append("ext3", getExt3())
                .append("jbsegyName", getJbsegyName())
                .append("xbsegyName", getXbsegyName())
                .toString();
    }
}
