package com.ruoyi.project.ys.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 会议模板对象 hyjyxx_mb
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
public class HyjyxxMb extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 模板名称 */
    @Excel(name = "模板名称")
    private String mbmc;

    /** 模板内容 */
    @Excel(name = "模板内容")
    private String mbnr;

    /** 是否默认 */
    @Excel(name = "是否默认")
    private String sfmr;

    /** 排序 */
    @Excel(name = "排序")
    private Long px;

    /** 解析完成时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "解析完成时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date jxwcsj;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    /** 备用1 */
    @Excel(name = "备用1")
    private String ext1;

    /** 备用2 */
    @Excel(name = "备用2")
    private String ext2;

    /** 备用3 */
    @Excel(name = "备用3")
    private String ext3;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setMbmc(String mbmc) 
    {
        this.mbmc = mbmc;
    }

    public String getMbmc() 
    {
        return mbmc;
    }

    public void setMbnr(String mbnr) 
    {
        this.mbnr = mbnr;
    }

    public String getMbnr() 
    {
        return mbnr;
    }

    public void setSfmr(String sfmr) 
    {
        this.sfmr = sfmr;
    }

    public String getSfmr() 
    {
        return sfmr;
    }

    public void setPx(Long px) 
    {
        this.px = px;
    }

    public Long getPx() 
    {
        return px;
    }

    public void setJxwcsj(Date jxwcsj) 
    {
        this.jxwcsj = jxwcsj;
    }

    public Date getJxwcsj() 
    {
        return jxwcsj;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    public void setExt1(String ext1) 
    {
        this.ext1 = ext1;
    }

    public String getExt1() 
    {
        return ext1;
    }

    public void setExt2(String ext2) 
    {
        this.ext2 = ext2;
    }

    public String getExt2() 
    {
        return ext2;
    }

    public void setExt3(String ext3) 
    {
        this.ext3 = ext3;
    }

    public String getExt3() 
    {
        return ext3;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("mbmc", getMbmc())
            .append("mbnr", getMbnr())
            .append("sfmr", getSfmr())
            .append("px", getPx())
            .append("jxwcsj", getJxwcsj())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("ext1", getExt1())
            .append("ext2", getExt2())
            .append("ext3", getExt3())
            .toString();
    }
}
