package com.ruoyi.project.dz.utils;

import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.framework.web.domain.BaseEntity;

import java.util.ArrayList;
/**
 * 每个segy文件的卷头数据
 * 对应2002年segy数据规范
 * 
 * 
 * @author dingyi
 *
 */
public class SegyTextFileHeader extends BaseEntity {
	private ArrayList<String> txtHeader=new ArrayList<String>(40);
//    C 3 First inline:855    Last inline:1228
    int first_inline;//第一个纵向测线
    int last_inline;//最后一个纵向测线
//    C 4 First xline:187    Last xline:1026
    int first_xline;//第一个横向测线
    int last_xline;//最后一个横向测线
//    C 5 xmin:14710960.00    xmax:14731940.00   inline spacing:25.00
    Double xmin;//最小X坐标
    Double xmax;//最大X坐标
    Double inline_spacing;//纵向测线间隔
//    C 6 ymin:4429512.00    ymax:14731940.00   inline spacing:25.00
    Double ymin;//最小y坐标
    Double ymax;//最大y坐标
    Double inline_spacing_hx;//横向测线间隔
//    C 7 Time min(ms):3590.00    max:3804.00   delta:0.25
//    C 8
//    C 9
//    C10 Amplitude min:1.67 max:1.87
//    C11 Trace sample format: IBM_FLOAT(1)
//    C12 Coordinate scale factor:1
//    C13
//    C14 Binary header locations:
//    C15 Sample interval             : bytes 17-18
//    C16 Number of samples per trace : bytes 21-22
//    C17 Trace date format           : bytes 25-26
//    C18
//    C19 Trace header locations:
//    C20 Inline number               : bytes 9-12
//    C21 Xline number                : bytes 21-24
//    C22 Coordinate scale factor     : bytes 71-72
//    C23 X coordinate                : bytes 73-76
//    C24 Y coordinate                : bytes 77-80
//    C25 Trace start time/depth      : bytes 109-110
//    C26 Number of samples per trace : bytes 115-116
//    C27 Sample interval             : bytes 117-118


    /**
	 * 根据读到的字节流构造卷头对象
	 * @param b  字节流
	 */
	public SegyTextFileHeader(byte[] b){
		for(int i=0;i<40;i++){
			StringBuffer sb=new StringBuffer(80);
			for(int j=0;j<80;j++){
				sb.append((char)b[i*80+j]);
			}
			txtHeader.add(i,sb.toString());
            getInfo(sb.toString());
		}
	}
	
	/**
	 * 判断卷头数据是否有效
	 * 依据2002年segy数据规范
	 * 判断依据：每一行均以大写C开头
	 * @return
	 */
	public boolean isValid(){
		for(String s:txtHeader){
			if(!s.startsWith("C"))
				return false;
		}
		return true;
	}


	public void getInfo(String str){

	    if (StringUtils.isNotEmpty(str) && str.length() > 4 && str.startsWith("C 3 ")) {
            String s2 = str.substring(4, str.length()); //去掉 "C 1 " 这些开头

            String param_name_1 = s2.substring(0, s2.indexOf(":"));//获取一个属性名称 : 前的内容
            String param_value_1 = s2.substring(s2.indexOf(":") + 1, s2.indexOf(" ", s2.indexOf(":")));//之后到空格前的内容
            System.out.println(" 读取内容 " + param_name_1 + " : " + param_value_1);
            first_inline = Integer.valueOf(param_value_1);

            //第二个参数
            String s3 = s2.substring(s2.indexOf(" ", s2.indexOf(":")) + 1, s2.length());//第一个:之后第一个空格的位置 往后开始截取
            s3 = s3.trim();
            String param_name_2 = s3.substring(0, s3.indexOf(":"));//获取一个属性名称 : 前的内容
            String param_value_2 = s3.substring(s3.indexOf(":") + 1, s3.length());//之后到空格前的内容
            System.out.println(" 读取内容 " + param_name_2 + " : " + param_value_2);
            last_inline = Integer.valueOf(param_value_2);

        }
	    if (StringUtils.isNotEmpty(str) && str.length() > 4 && str.startsWith("C 4 ")) {
            String s2 = str.substring(4, str.length()); //去掉 "C 1 " 这些开头

            String param_name_1 = s2.substring(0, s2.indexOf(":"));//获取一个属性名称 : 前的内容
            String param_value_1 = s2.substring(s2.indexOf(":") + 1, s2.indexOf(" ", s2.indexOf(":")));//之后到空格前的内容
            System.out.println(" 读取内容 " + param_name_1 + " : " + param_value_1);
            first_xline = Integer.valueOf(param_value_1);

            //第二个参数
            String s3 = s2.substring(s2.indexOf(" ", s2.indexOf(":")) + 1, s2.length());//第一个:之后第一个空格的位置 往后开始截取
            s3 = s3.trim();
            String param_name_2 = s3.substring(0, s3.indexOf(":"));//获取一个属性名称 : 前的内容
            String param_value_2 = s3.substring(s3.indexOf(":") + 1, s3.length());//之后到空格前的内容
            System.out.println(" 读取内容 " + param_name_2 + " : " + param_value_2);
            last_xline = Integer.valueOf(param_value_2);

        }
	    if (StringUtils.isNotEmpty(str) && str.length() > 4 && str.startsWith("C 5 ")) {
            String s2 = str.substring(4, str.length()); //去掉 "C 1 " 这些开头

            String param_name_1 = s2.substring(0, s2.indexOf(":"));//获取一个属性名称 : 前的内容
            String param_value_1 = s2.substring(s2.indexOf(":") + 1, s2.indexOf(" ", s2.indexOf(":")));//之后到空格前的内容
            System.out.println(" 读取内容 " + param_name_1 + " : " + param_value_1);
            xmin = Double.valueOf(param_value_1);

            //第二个参数
            String s3 = s2.substring(s2.indexOf(" ", s2.indexOf(":")) + 1, s2.length());//第一个:之后第一个空格的位置 往后开始截取
            s3 = s3.trim();
            String param_name_2 = s3.substring(0, s3.indexOf(":"));//获取一个属性名称 : 前的内容
            String param_value_2 = s3.substring(s3.indexOf(":") + 1, s3.indexOf(" ", s3.indexOf(":")));//之后到空格前的内容
            System.out.println(" 读取内容 " + param_name_2 + " : " + param_value_2);
            xmax = Double.valueOf(param_value_2);

            //第三个参数
            String s4 = s3.substring(s3.indexOf(" ", s3.indexOf(":")) + 1, s3.length());//第一个:之后第一个空格的位置 往后开始截取
            s4 = s4.trim();
            String param_name_3 = s4.substring(0, s4.indexOf(":"));//获取一个属性名称 : 前的内容
            String param_value_3 = s4.substring(s4.indexOf(":") + 1, s4.length());//之后到空格前的内容
            System.out.println(" 读取内容 " + param_name_3 + " : " + param_value_3);
            inline_spacing = Double.valueOf(param_value_3);

        }
	    if (StringUtils.isNotEmpty(str) && str.length() > 4 && str.startsWith("C 6 ")) {
            String s2 = str.substring(4, str.length()); //去掉 "C 1 " 这些开头

            String param_name_1 = s2.substring(0, s2.indexOf(":"));//获取一个属性名称 : 前的内容
            String param_value_1 = s2.substring(s2.indexOf(":") + 1, s2.indexOf(" ", s2.indexOf(":")));//之后到空格前的内容
            System.out.println(" 读取内容 " + param_name_1 + " : " + param_value_1);
            ymin = Double.valueOf(param_value_1);

            //第二个参数
            String s3 = s2.substring(s2.indexOf(" ", s2.indexOf(":")) + 1, s2.length());//第一个:之后第一个空格的位置 往后开始截取
            s3 = s3.trim();
            String param_name_2 = s3.substring(0, s3.indexOf(":"));//获取一个属性名称 : 前的内容
            String param_value_2 = s3.substring(s3.indexOf(":") + 1, s3.indexOf(" ", s3.indexOf(":")));//之后到空格前的内容
            System.out.println(" 读取内容 " + param_name_2 + " : " + param_value_2);
            ymax = Double.valueOf(param_value_2);

            //第三个参数
            String s4 = s3.substring(s3.indexOf(" ", s3.indexOf(":")) + 1, s3.length());//第一个:之后第一个空格的位置 往后开始截取
            s4 = s4.trim();
            String param_name_3 = s4.substring(0, s4.indexOf(":"));//获取一个属性名称 : 前的内容
            String param_value_3 = s4.substring(s4.indexOf(":") + 1, s4.length());//之后到空格前的内容
            System.out.println(" 读取内容 " + param_name_3 + " : " + param_value_3);
            inline_spacing_hx = Double.valueOf(param_value_3);

        }
    }


    public int getFirst_inline() {
        return first_inline;
    }

    public void setFirst_inline(int first_inline) {
        this.first_inline = first_inline;
    }

    public int getLast_inline() {
        return last_inline;
    }

    public void setLast_inline(int last_inline) {
        this.last_inline = last_inline;
    }

    public int getFirst_xline() {
        return first_xline;
    }

    public void setFirst_xline(int first_xline) {
        this.first_xline = first_xline;
    }

    public int getLast_xline() {
        return last_xline;
    }

    public void setLast_xline(int last_xline) {
        this.last_xline = last_xline;
    }

    public Double getXmin() {
        return xmin;
    }

    public void setXmin(Double xmin) {
        this.xmin = xmin;
    }

    public Double getXmax() {
        return xmax;
    }

    public void setXmax(Double xmax) {
        this.xmax = xmax;
    }

    public Double getInline_spacing() {
        return inline_spacing;
    }

    public void setInline_spacing(Double inline_spacing) {
        this.inline_spacing = inline_spacing;
    }

    public Double getYmin() {
        return ymin;
    }

    public void setYmin(Double ymin) {
        this.ymin = ymin;
    }

    public Double getYmax() {
        return ymax;
    }

    public void setYmax(Double ymax) {
        this.ymax = ymax;
    }

    public Double getInline_spacing_hx() {
        return inline_spacing_hx;
    }

    public void setInline_spacing_hx(Double inline_spacing_hx) {
        this.inline_spacing_hx = inline_spacing_hx;
    }
}
