package com.ruoyi.project.ys.service.impl;

import java.util.ArrayList;
import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.ys.mapper.YscgFileRoleMapper;
import com.ruoyi.project.ys.domain.YscgFileRole;
import com.ruoyi.project.ys.service.IYscgFileRoleService;

import static com.ruoyi.common.utils.SecurityUtils.getUserId;

/**
 * 成果单文件权限管理Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-10-31
 */
@Service
public class YscgFileRoleServiceImpl implements IYscgFileRoleService 
{
    @Autowired
    private YscgFileRoleMapper yscgFileRoleMapper;

    /**
     * 查询成果单文件权限管理
     * 
     * @param id 成果单文件权限管理主键
     * @return 成果单文件权限管理
     */
    @Override
    public YscgFileRole selectYscgFileRoleById(Long id)
    {
        return yscgFileRoleMapper.selectYscgFileRoleById(id);
    }

    /**
     * 查询成果单文件权限管理列表
     * 
     * @param yscgFileRole 成果单文件权限管理
     * @return 成果单文件权限管理
     */
    @Override
    public List<YscgFileRole> selectYscgFileRoleList(YscgFileRole yscgFileRole)
    {
        return yscgFileRoleMapper.selectYscgFileRoleList(yscgFileRole);
    }

    /**
     * 新增成果单文件权限管理
     * 
     * @param yscgFileRole 成果单文件权限管理
     * @return 结果
     */
    @Override
    public int insertYscgFileRole(YscgFileRole yscgFileRole)
    {
        yscgFileRole.setCreatedBy(getUserId()+"");
        yscgFileRole.setCreatedTime(DateUtils.getNowDate());
        return yscgFileRoleMapper.insertYscgFileRole(yscgFileRole);
    }

    /**
     * 修改成果单文件权限管理
     * 
     * @param yscgFileRole 成果单文件权限管理
     * @return 结果
     */
    @Override
    public int updateYscgFileRole(YscgFileRole yscgFileRole)
    {
        yscgFileRole.setUpdateBy(getUserId()+"");
        yscgFileRole.setUpdateTime(DateUtils.getNowDate());
        return yscgFileRoleMapper.updateYscgFileRole(yscgFileRole);
    }

    /**
     * 批量删除成果单文件权限管理
     * 
     * @param ids 需要删除的成果单文件权限管理主键
     * @return 结果
     */
    @Override
    public int deleteYscgFileRoleByIds(Long[] ids)
    {
        return yscgFileRoleMapper.deleteYscgFileRoleByIds(ids);
    }

    /**
     * 删除成果单文件权限管理信息
     * 
     * @param id 成果单文件权限管理主键
     * @return 结果
     */
    @Override
    public int deleteYscgFileRoleById(Long id)
    {
        return yscgFileRoleMapper.deleteYscgFileRoleById(id);
    }

    @Override
    public int batchYscgFileRole(Long fileid, Long[] userIds)
    {
        // 新增用户与角色管理
        List<YscgFileRole> list = new ArrayList<YscgFileRole>();
        for (Long userId : userIds)
        {
            YscgFileRole ur = new YscgFileRole();
            ur.setUserId(userId);
            ur.setFileid(fileid);
            ur.setIsshow("Y");
            ur.setCreatedBy(getUserId()+"");
            ur.setCreatedTime(DateUtils.getNowDate());
            list.add(ur);
        }
        return yscgFileRoleMapper.batchYscgFileRole(list);
    }
}
