package com.ruoyi.project.ys.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 验收前期-项目信息对象 ysqq_xmxx
 *
 * @author ruoyi
 * @date 2025-09-18
 */
public class YsqqXmxx extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 项目名称 */
    @Excel(name = "项目名称")
    private String xmmc;

    /** 区块 */
    @Excel(name = "区块")
    private String qk;

    /** 项目简介 */
    @Excel(name = "项目简介")
    private String xmjj;

    /** 结合单位 */
    @Excel(name = "结合单位")
    private String jhdw;

    /** 甲方单位 */
    @Excel(name = "甲方单位")
    private String jfdw;

    /** x轴最小值 */
    @Excel(name = "x轴最小值")
    private BigDecimal xmin;

    /** x轴最大值 */
    @Excel(name = "x轴最大值")
    private BigDecimal xmax;

    /** y轴最小值 */
    @Excel(name = "y轴最小值")
    private BigDecimal ymin;

    /** y轴最大值 */
    @Excel(name = "y轴最大值")
    private BigDecimal ymax;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    /** 备用1 */
    @Excel(name = "备用1")
    private String ext1;

    /** 备用2 */
    @Excel(name = "备用2")
    private String ext2;

    /** 备用3 */
    @Excel(name = "备用3")
    private String ext3;

    /** 项目状态 */
    @Excel(name = "项目状态")
    private String xmzt;

    /** 项目日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "项目日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date xmrq;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }

    public void setXmmc(String xmmc)
    {
        this.xmmc = xmmc;
    }

    public String getXmmc()
    {
        return xmmc;
    }

    public void setQk(String qk)
    {
        this.qk = qk;
    }

    public String getQk()
    {
        return qk;
    }

    public void setXmjj(String xmjj)
    {
        this.xmjj = xmjj;
    }

    public String getXmjj()
    {
        return xmjj;
    }

    public void setJhdw(String jhdw)
    {
        this.jhdw = jhdw;
    }

    public String getJhdw()
    {
        return jhdw;
    }

    public void setJfdw(String jfdw)
    {
        this.jfdw = jfdw;
    }

    public String getJfdw()
    {
        return jfdw;
    }

    public void setXmin(BigDecimal xmin)
    {
        this.xmin = xmin;
    }

    public BigDecimal getXmin()
    {
        return xmin;
    }

    public void setXmax(BigDecimal xmax)
    {
        this.xmax = xmax;
    }

    public BigDecimal getXmax()
    {
        return xmax;
    }

    public void setYmin(BigDecimal ymin)
    {
        this.ymin = ymin;
    }

    public BigDecimal getYmin()
    {
        return ymin;
    }

    public void setYmax(BigDecimal ymax)
    {
        this.ymax = ymax;
    }

    public BigDecimal getYmax()
    {
        return ymax;
    }

    public void setCreatedBy(String createdBy)
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy()
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime)
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime()
    {
        return createdTime;
    }

    public void setExt1(String ext1)
    {
        this.ext1 = ext1;
    }

    public String getExt1()
    {
        return ext1;
    }

    public void setExt2(String ext2)
    {
        this.ext2 = ext2;
    }

    public String getExt2()
    {
        return ext2;
    }

    public void setExt3(String ext3)
    {
        this.ext3 = ext3;
    }

    public String getExt3()
    {
        return ext3;
    }

    public void setXmzt(String xmzt)
    {
        this.xmzt = xmzt;
    }

    public String getXmzt()
    {
        return xmzt;
    }

    public void setXmrq(Date xmrq)
    {
        this.xmrq = xmrq;
    }

    public Date getXmrq()
    {
        return xmrq;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("xmmc", getXmmc())
                .append("qk", getQk())
                .append("xmjj", getXmjj())
                .append("jhdw", getJhdw())
                .append("jfdw", getJfdw())
                .append("xmin", getXmin())
                .append("xmax", getXmax())
                .append("ymin", getYmin())
                .append("ymax", getYmax())
                .append("createdBy", getCreatedBy())
                .append("createdTime", getCreatedTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .append("ext1", getExt1())
                .append("ext2", getExt2())
                .append("ext3", getExt3())
                .append("xmzt", getXmzt())
                .append("xmrq", getXmrq())
                .toString();
    }
}
