package com.ruoyi.project.dz.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.file.FileUtils;
import com.ruoyi.framework.config.RuoYiConfig;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.project.dz.utils.Point;
import com.ruoyi.project.dz.utils.SegyReadUtil;
import com.ruoyi.project.dz.utils.SegyReader;
import com.ruoyi.project.dz.utils.SegyTextFileHeader;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * 地震
 * 地震工区数据返回，segy文件的读取，切面数据返回
 * @author ruoyi
 */
@RestController
@RequestMapping("/ndy/dz")
public class DzController extends BaseController
{
    private static final Logger log = LoggerFactory.getLogger(DzController.class);

//    @Autowired
//    private ServerConfig serverConfig;

    private static final String FILE_DELIMETER = ",";

//    private static String tempPath = "/root/nandongyong/temp.Sgy";
//    private static String tempPath = "C:\\ruoyi\\uploadPath\\11-VPVS.Sgy";
//    private static String tempPath = "D:\\qianhe\\file\\地震\\cgm及配对的效果图\\line603_out.segy";
    private static String tempPath = "D:\\qianhe\\file\\地震\\20250715-04segy\\qt_line662_stk.sgy";
//    private static String tempPath = "D:\\qianhe\\file\\地震\\segy对比图\\line603_out_new_20250508.segy";
//
//    private static String inPath = "/root/nandongyong/1-VPVS.Sgy";
//    private static String inPath = "D:\\SoftWork\\2023-06-05 物地震\\地震\\1-VPVS.Sgy";
    private static String inPath = "D:\\qianhe\\file\\地震\\segy对比图\\line603_out_new_20250508.segy";

    /**
     * 获取segy文件数据返回前端
     * 文件流
     */
    @GetMapping("/getSegyDataFile")
    public void getSegyDataFile(String fileName, HttpServletResponse response, HttpServletRequest request)
    {
        try
        {
            if (!FileUtils.checkAllowDownload(fileName))
            {
                throw new Exception(StringUtils.format("文件名称({})非法，不允许下载。 ", fileName));
            }
            String realFileName = System.currentTimeMillis() + fileName.substring(fileName.indexOf("_") + 1);
            String filePath = RuoYiConfig.getDownloadPath() + fileName;
            filePath = "/root" + filePath;
//            filePath = "D:\\SoftWork\\2023-06-05 物地震\\地震\\temp.Sgy";
            filePath = tempPath;
            System.out.println("/n/n filePath = " + filePath + "/n/n");
//            String filePath = "/root/D:/home/ruoyi/uploadPath/avatar/2023/06/13/density.segy";
//            String filePath = "D:\\SoftWork\\2023-06-05 钻井院难动用\\density.segy";
//            String realFileName = "density.segy";

            response.setContentType(MediaType.APPLICATION_OCTET_STREAM_VALUE);
            FileUtils.setAttachmentResponseHeader(response, realFileName);
            FileUtils.writeBytes(filePath, response.getOutputStream());

        }
        catch (Exception e)
        {
            log.error("下载文件失败", e);
        }
    }
    @GetMapping("/getSegyDataFile2")
    public void getSegyDataFile2(String fileName, HttpServletResponse response, HttpServletRequest request)
    {
        try
        {
            if (!FileUtils.checkAllowDownload(fileName))
            {
                throw new Exception(StringUtils.format("文件名称({})非法，不允许下载。 ", fileName));
            }
            String realFileName = System.currentTimeMillis() + fileName.substring(fileName.indexOf("_") + 1);
            String filePath = RuoYiConfig.getDownloadPath() + fileName;
            filePath = "/root" + filePath;
//            filePath = "D:\\SoftWork\\2023-06-05 物地震\\地震\\temp.Sgy";
            filePath = tempPath;
            System.out.println("/n/n filePath = " + filePath + "/n/n");
//            String filePath = "/root/D:/home/ruoyi/uploadPath/avatar/2023/06/13/density.segy";
//            String filePath = "D:\\SoftWork\\2023-06-05 钻井院难动用\\density.segy";
//            String realFileName = "density.segy";

            response.setContentType(MediaType.APPLICATION_OCTET_STREAM_VALUE);
            FileUtils.setAttachmentResponseHeader(response, realFileName);
            FileUtils.writeBytes(filePath, response.getOutputStream());

        }
        catch (Exception e)
        {
            log.error("下载文件失败", e);
        }
    }

    /**
     * 获取工区坐标范围
     */
    @GetMapping("/getGqInfo")
    public SegyTextFileHeader getGqInfo(String fileName, HttpServletResponse response, HttpServletRequest request)
    {
        SegyReader reader = new SegyReader(inPath);
//        SegyReader reader = new SegyReader("D:\\SoftWork\\2023-06-05 物地震\\地震\\1-VPVS.Sgy");
        SegyTextFileHeader gq = null;
        try {
            gq = reader.getFileHeader3200();
        } catch (Exception e) {
            e.printStackTrace();
        }

        return gq;
    }

    /**
     * 地震任意切面
     * 传递一组坐标 代表一条折线 查询线上所有的点 然后查询对应位数的数据
     */
    @RequestMapping("/getDzqm")
    public void getDzqm(String fileName, @RequestBody String pointstr, HttpServletResponse response, HttpServletRequest request)
    {
        //pointstr = request.getParameter("pointstr");

        List<Point> points = new ArrayList<>();
        JSONArray json = JSONArray.parseArray(pointstr); // 首先把字符串转成 JSONArray  对象
        if(json.size() > 0){
            for(int i=0; i < json.size(); i++){
                JSONObject job = json.getJSONObject(i);  // 遍历 jsonarray 数组，把每一个对象转成 json 对象
                int x = Integer.valueOf(String.valueOf(job.get("x")));  // 得到 每个对象中的属性值
                int y = Integer.valueOf(String.valueOf(job.get("y")));  // 得到 每个对象中的属性值

                Point tm = new Point();
                tm.setX(x);
                tm.setY(y);
                points.add(tm);
            }
        }

        fileName = inPath;
        String outPath = tempPath;

//        fileName = "D:\\SoftWork\\2023-06-05 物地震\\地震\\1-VPVS.Sgy";
//        String outPath = "D:\\SoftWork\\2023-06-05 物地震\\地震\\temp.Sgy";

        try {
            SegyReadUtil.outFile(fileName, points, outPath);

            response.setContentType(MediaType.APPLICATION_OCTET_STREAM_VALUE);
            FileUtils.setAttachmentResponseHeader(response, "realFileName");
            FileUtils.writeBytes(outPath, response.getOutputStream());
        } catch (Exception e) {
            log.error("下载文件失败", e);
        }
    }


    /**
     *  RemoteSeismicDataSource
     *  三维地震切面 服务器处理
     *  Example:
     *  http://loclahost:8080/seismicreader?json=%7B%22file%22:%22seismicdata/cdp_stack.sgy%22,%22type%22:%22info%22,%22query%22:%7B%7D,%22sourceId%22:-1%7D
     *  Where query string parameters:
     *  json:{"file":"seismicdata/cdp_stack.sgy","type":"info","query":{},"sourceId":-1}
     **/
    @RequestMapping("/qRemoteSeismicReader2222")
    public void qRemoteSeismicReader(String json, HttpServletResponse response, HttpServletRequest request) {

        System.out.println(json);

    }


    /******************************************************************************************************************/
    /**********************************  地震三维切片  *****************************************************************/
    /******************************************************************************************************************/

    /**
     *
     * json: {"file":"data/seismic/Gullfaks_Amplitude.xgy","query":{},"sourceId":-1}
     * */
    @RequestMapping("/qRemoteSeismicReader/json/seismicdata")
    public JSONObject seismicdata(String json) {
        //接收参数
        System.out.println(json);
        JSONObject input = JSONObject.parseObject(json);
        String file = input.getString("file");
        String sourceId = input.getString("sourceId");
        JSONObject query = input.getJSONObject("query");


        //返回值
        JSONObject output = new JSONObject();
        output.put("version", "1");
        output.put("displayName", "Gullfaks_Amplitude");
        JSONArray keys = new JSONArray();
        JSONObject k1 = new JSONObject();
        k1.put("key", "INLINE");
        k1.put("min", 187);
        k1.put("max", 1026);
        k1.put("increment", 1);
        k1.put("sampleKey", false);
        keys.add(k1);
        JSONObject k2 = new JSONObject();
        k2.put("key", "XLINE");
        k2.put("min", 855);
        k2.put("max", 1228);
        k2.put("increment", 1);
        k2.put("sampleKey", false);
        keys.add(k2);
        JSONObject k3 = new JSONObject();
        k3.put("key", "Depth");
        k3.put("min", 5402);
        k3.put("max", 5901);
        k3.put("increment", 0.58);
        k3.put("sampleKey", true);
        keys.add(k3);
        output.put("keys", keys);

        output.put("numberOfSamples", 857);
        output.put("numberOfTraces", 314160);
        output.put("startValue", 5402);
        output.put("sampleRate", 0.58);


        JSONObject statistics = new JSONObject();
        statistics.put("min", -71);
        statistics.put("max", 73);
        statistics.put("mean", 7.7803535);
        statistics.put("rms", 10.103634);
        statistics.put("percentiles", new int[]{0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,
                4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,11,11,
                12,12,12,12,13,13,13,14,14,15,15,15,16,16,17,18,18,19,20,21,22,24,28,73});
        output.put("statistics", statistics);


        JSONArray gridCoordinates = new JSONArray();
        JSONObject g1 = new JSONObject();
        g1.put("values", new double[]{ 187, 855, 4429511, 14710962});
        gridCoordinates.add(g1);
        JSONObject g2 = new JSONObject();
        g2.put("values", new double[]{ 187, 1228, 4438836, 14710962});
        gridCoordinates.add(g2);
        JSONObject g3 = new JSONObject();
        g3.put("values", new double[]{ 1026, 855, 4429511, 14731937});
        gridCoordinates.add(g3);
        output.put("gridCoordinates", gridCoordinates);


        JSONObject traceHeader = new JSONObject();
        JSONArray fields = new JSONArray();
        JSONObject fields_1 = new JSONObject();
        fields_1.put("name", "TSSN");
        fields_1.put("id", 0);
        fields_1.put("type", "UInt");
        fields_1.put("size", 4);
        fields.add(fields_1);
        traceHeader.put("fields", fields);
        traceHeader.put("size", 144);
        output.put("traceHeader", traceHeader_static);


        JSONObject mapTraceHeader = new JSONObject();
        JSONArray mapfields = new JSONArray();
        JSONObject mapfields_1 = new JSONObject();
        mapfields_1.put("name", "INLINE");
        mapfields_1.put("id", 0);
        mapfields_1.put("type", "Float");
        mapfields_1.put("size", 4);
        mapfields.add(mapfields_1);
        JSONObject mapfields_2 = new JSONObject();
        mapfields_2.put("name", "XLINE");
        mapfields_2.put("id", 1);
        mapfields_2.put("type", "Float");
        mapfields_2.put("size", 4);
        mapfields.add(mapfields_2);
        JSONObject mapfields_3 = new JSONObject();
        mapfields_3.put("name", "TraceNumber");
        mapfields_3.put("id", 1100);
        mapfields_3.put("type", "Double");
        mapfields_3.put("size", 8);
        mapfields.add(mapfields_3);
        mapTraceHeader.put("fields", mapfields);
        mapTraceHeader.put("size", 16);
        output.put("mapTraceHeader", mapTraceHeader);


        JSONArray outline = new JSONArray();
        JSONArray outline_t = new JSONArray();
        outline_t.add(new double[]{ 186.5, 854.5});
        outline_t.add(new double[]{ 1026.5, 854.5});
        outline_t.add(new double[]{ 1026.5, 1228.5});
        outline_t.add(new double[]{ 186.5, 1228.5});
        outline.add(outline_t);
        output.put("outline", outline);


        output.put("traceOrders", new int[]{ 1, 2});
        output.put("units", 2);
        output.put("zUnit", "m");
        output.put("indexType", "VOLUME");

        JSONObject volumeKeyNames = new JSONObject();
        volumeKeyNames.put("i", "INLINE");
        volumeKeyNames.put("j", "XLINE");
        output.put("volumeKeyNames", volumeKeyNames);
        output.put("volumeDefaultKeyNames", volumeKeyNames);

        JSONObject xyKeyNames = new JSONObject();
        xyKeyNames.put("xKeyName", "CDPX");
        xyKeyNames.put("yKeyName", "CDPY");
        xyKeyNames.put("multiplierType", 1);
        xyKeyNames.put("multiplierFieldName", "LOC SCALER");
        output.put("xyKeyNames", xyKeyNames);


        output.put("epsgCode", "32631:unknown");
        output.put("regular", false);
        output.put("seismicFormatName", "Indexed-Segy");

        JSONArray ebcdic = new JSONArray();
        ebcdic.add(" C 1 SEGY OUTPUT FROM Petrel 2011.1 (64-bit) alpha Wednesday, November 03 2010 11");
        output.put("ebcdic", ebcdic);

        return output;
    }


    @RequestMapping("/qRemoteSeismicReader/json/seismicbinaryheader")
    public void seismicbinaryheader(String json, HttpServletResponse response) {
        //接收参数
        System.out.println(json);
        JSONObject input = JSONObject.parseObject(json);
        String file = input.getString("file");
        String outputType = input.getString("outputType");
        //JSONObject query = input.getJSONObject("query");

//        String fileName = "D:\\SoftWork\\2023-06-05 物地震\\地震\\1-VPVS.Sgy";
//        String outPath = "D:\\SoftWork\\2023-06-05 物地震\\地震\\temp.Sgy";

        String fileName = inPath;
        String outPath = tempPath;


        try {
            byte[] data = SegyReadUtil.getFileHeaderByteArr400(fileName);

            response.setContentType(MediaType.APPLICATION_OCTET_STREAM_VALUE);
            FileUtils.setAttachmentResponseHeader(response, "realFileName");
            IOUtils.write(data, response.getOutputStream());
        } catch (Exception e) {
            log.error("下载文件失败", e);
        }
    }



    @RequestMapping("/qRemoteSeismicReader/json/seismicquery")
    public JSONObject seismicquery(String json) {
        //接收参数
        System.out.println(json);
        JSONObject input = JSONObject.parseObject(json);
        String file = input.getString("file");
        String sourceId = input.getString("sourceId");
        String queryId = input.getString("queryId");
        JSONObject query = input.getJSONObject("query");
        JSONObject data = input.getJSONObject("data");
        //  query内容
        JSONArray query_keys = query.getJSONArray("keys");
        JSONObject query_options = query.getJSONObject("options");
        JSONObject query_emptyTracesKey = query.getJSONObject("emptyTracesKey");

        int query_keys_size = query_keys.size();


        //返回值
        JSONObject output = new JSONObject();
        output.put("version", 1.1);
        output.put("sections", 374);
        output.put("numberOfSamples", 857);
        output.put("numberOfTraces", 374);
        output.put("startValue", 5402);
        output.put("sampleRate", 0.58);
        JSONObject statistics = new JSONObject();
        statistics.put("min", -71);
        statistics.put("max", 73);
        statistics.put("mean", 7.7803535);
        statistics.put("rms", 10.103634);
        statistics.put("percentiles", new int[]{0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,
                4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,11,11,
                12,12,12,12,13,13,13,14,14,15,15,15,16,16,17,18,18,19,20,21,22,24,28,73});
        output.put("statistics", statistics);
        return output;
    }





    @RequestMapping("/qRemoteSeismicReader/json/seismictraces")
    public void seismictraces(String json, HttpServletResponse response) {
        //接收参数
        System.out.println(json);
        JSONObject input = JSONObject.parseObject(json);
        String file = input.getString("file");
        String outputType = input.getString("outputType");
        //JSONObject query = input.getJSONObject("query");

//        String fileName = "D:\\SoftWork\\2023-06-05 物地震\\地震\\1-VPVS.Sgy";
//        String outPath = "D:\\SoftWork\\2023-06-05 物地震\\地震\\temp.Sgy";

        String fileName = inPath;
        String outPath = tempPath;


        try {
            byte[] data = SegyReadUtil.getTest(fileName);

            response.setContentType(MediaType.APPLICATION_OCTET_STREAM_VALUE);
            FileUtils.setAttachmentResponseHeader(response, "realFileName");
            IOUtils.write(data, response.getOutputStream());
        } catch (Exception e) {
            log.error("下载文件失败", e);
        }
    }
    @RequestMapping("/qRemoteSeismicReader/json/enumeratedtraces")
    public void enumeratedtraces(String json, HttpServletResponse response) {
        //接收参数
        System.out.println(json);
        JSONObject input = JSONObject.parseObject(json);
        String file = input.getString("file");
        String outputType = input.getString("outputType");
        //JSONObject query = input.getJSONObject("query");

//        String fileName = "D:\\SoftWork\\2023-06-05 物地震\\地震\\1-VPVS.Sgy";
//        String outPath = "D:\\SoftWork\\2023-06-05 物地震\\地震\\temp.Sgy";

        String fileName = inPath;
        String outPath = tempPath;


        try {
            byte[] data = SegyReadUtil.getTest(fileName);

            response.setContentType(MediaType.APPLICATION_OCTET_STREAM_VALUE);
            FileUtils.setAttachmentResponseHeader(response, "realFileName");
            IOUtils.write(data, response.getOutputStream());
        } catch (Exception e) {
            log.error("下载文件失败", e);
        }
    }










    private String traceHeader_static = "{\n" +
            "        \"fields\": [\n" +
            "            {\n" +
            "                \"name\": \"TSSN\",\n" +
            "                \"id\": 0,\n" +
            "                \"type\": \"UInt\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"FIELD REC\",\n" +
            "                \"id\": 1,\n" +
            "                \"type\": \"UInt\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"FIELD TR\",\n" +
            "                \"id\": 2,\n" +
            "                \"type\": \"UInt\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"SHTPT ID\",\n" +
            "                \"id\": 3,\n" +
            "                \"type\": \"UInt\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"CDP\",\n" +
            "                \"id\": 4,\n" +
            "                \"type\": \"Int\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"CDPTR\",\n" +
            "                \"id\": 5,\n" +
            "                \"type\": \"UInt\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"TRACE ID\",\n" +
            "                \"id\": 6,\n" +
            "                \"type\": \"UShort\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"VERT SUM\",\n" +
            "                \"id\": 7,\n" +
            "                \"type\": \"UShort\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"HORZ SUM\",\n" +
            "                \"id\": 8,\n" +
            "                \"type\": \"UShort\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"DATA USE\",\n" +
            "                \"id\": 9,\n" +
            "                \"type\": \"UShort\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"OFFSET\",\n" +
            "                \"id\": 10,\n" +
            "                \"type\": \"Int\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"RCV ELEV\",\n" +
            "                \"id\": 11,\n" +
            "                \"type\": \"Int\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"SRC ELEV\",\n" +
            "                \"id\": 12,\n" +
            "                \"type\": \"Int\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"SRC DEPTH\",\n" +
            "                \"id\": 13,\n" +
            "                \"type\": \"UInt\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"RCV DATUM\",\n" +
            "                \"id\": 14,\n" +
            "                \"type\": \"Int\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"SRC DATUM\",\n" +
            "                \"id\": 15,\n" +
            "                \"type\": \"Int\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"SRC WATER DEPTH\",\n" +
            "                \"id\": 16,\n" +
            "                \"type\": \"Int\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"RCV WATER DEPTH\",\n" +
            "                \"id\": 17,\n" +
            "                \"type\": \"Int\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"ELEVATION SCALER\",\n" +
            "                \"id\": 18,\n" +
            "                \"type\": \"Short\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"LOC SCALER\",\n" +
            "                \"id\": 19,\n" +
            "                \"type\": \"Short\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"SRCX\",\n" +
            "                \"id\": 20,\n" +
            "                \"type\": \"UInt\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"SRCY\",\n" +
            "                \"id\": 21,\n" +
            "                \"type\": \"UInt\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"RCVX\",\n" +
            "                \"id\": 22,\n" +
            "                \"type\": \"UInt\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"RCVY\",\n" +
            "                \"id\": 23,\n" +
            "                \"type\": \"UInt\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"COORD UNITS\",\n" +
            "                \"id\": 24,\n" +
            "                \"type\": \"UShort\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"WEATHER VEL\",\n" +
            "                \"id\": 25,\n" +
            "                \"type\": \"UShort\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"SUBWEATHER VEL\",\n" +
            "                \"id\": 26,\n" +
            "                \"type\": \"UShort\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"SRC UPHOLE TIME\",\n" +
            "                \"id\": 27,\n" +
            "                \"type\": \"Short\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"RCV UPHOLE TIME\",\n" +
            "                \"id\": 28,\n" +
            "                \"type\": \"Short\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"SRC STATIC CORR\",\n" +
            "                \"id\": 29,\n" +
            "                \"type\": \"Short\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"RCV STATIC CORR\",\n" +
            "                \"id\": 30,\n" +
            "                \"type\": \"Short\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"TOTAL STATIC CORR\",\n" +
            "                \"id\": 31,\n" +
            "                \"type\": \"Short\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"LAG A\",\n" +
            "                \"id\": 32,\n" +
            "                \"type\": \"Short\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"LAG B\",\n" +
            "                \"id\": 33,\n" +
            "                \"type\": \"Short\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"START TIME\",\n" +
            "                \"id\": 214,\n" +
            "                \"type\": \"Short\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"MUTE START\",\n" +
            "                \"id\": 34,\n" +
            "                \"type\": \"Short\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"MUTE END\",\n" +
            "                \"id\": 35,\n" +
            "                \"type\": \"Short\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"SAMPLES IN TRACE\",\n" +
            "                \"id\": 36,\n" +
            "                \"type\": \"UShort\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"SAMPLE RATE\",\n" +
            "                \"id\": 37,\n" +
            "                \"type\": \"UShort\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"CDPX\",\n" +
            "                \"id\": 38,\n" +
            "                \"type\": \"UInt\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"CDPY\",\n" +
            "                \"id\": 39,\n" +
            "                \"type\": \"UInt\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"INLINE\",\n" +
            "                \"id\": 40,\n" +
            "                \"type\": \"Int\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"XLINE\",\n" +
            "                \"id\": 41,\n" +
            "                \"type\": \"Int\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"SHTPT NUM\",\n" +
            "                \"id\": 42,\n" +
            "                \"type\": \"UInt\",\n" +
            "                \"size\": 4\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"SURF TIME SCALER\",\n" +
            "                \"id\": 43,\n" +
            "                \"type\": \"Short\",\n" +
            "                \"size\": 2\n" +
            "            },\n" +
            "            {\n" +
            "                \"name\": \"TraceNumber\",\n" +
            "                \"id\": 1100,\n" +
            "                \"type\": \"Double\",\n" +
            "                \"size\": 8\n" +
            "            }\n" +
            "        ],\n" +
            "        \"size\": 144\n" +
            "    }";


}
