package com.ruoyi.project.ys.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 公用附件表对象 commun_file
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
public class CommunFile extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long ID;

    /** 业务id */
    @Excel(name = "业务id")
    private String ywid;

    /** 附件名称 */
    @Excel(name = "附件名称")
    private String fjmc;

    /** 附件地址 */
    @Excel(name = "附件地址")
    private String fjdz;

    /** 模块名称 */
    @Excel(name = "模块名称")
    private String mkmc;

    /** 附件类型 */
    @Excel(name = "附件类型")
    private String fjlx;

    /** 附件后缀 */
    @Excel(name = "附件后缀")
    private String fjhz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    /** 备用1 */
    @Excel(name = "备用1")
    private String ext1;

    /** 备用2 */
    @Excel(name = "备用2")
    private String ext2;

    /** 备用3 */
    @Excel(name = "备用3")
    private String ext3;

    public void setID(Long ID) 
    {
        this.ID = ID;
    }

    public Long getID() 
    {
        return ID;
    }

    public void setYwid(String ywid) 
    {
        this.ywid = ywid;
    }

    public String getYwid() 
    {
        return ywid;
    }

    public void setFjmc(String fjmc) 
    {
        this.fjmc = fjmc;
    }

    public String getFjmc() 
    {
        return fjmc;
    }

    public void setFjdz(String fjdz) 
    {
        this.fjdz = fjdz;
    }

    public String getFjdz() 
    {
        return fjdz;
    }

    public void setMkmc(String mkmc) 
    {
        this.mkmc = mkmc;
    }

    public String getMkmc() 
    {
        return mkmc;
    }

    public void setFjlx(String fjlx) 
    {
        this.fjlx = fjlx;
    }

    public String getFjlx() 
    {
        return fjlx;
    }

    public void setFjhz(String fjhz) 
    {
        this.fjhz = fjhz;
    }

    public String getFjhz() 
    {
        return fjhz;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    public void setExt1(String ext1) 
    {
        this.ext1 = ext1;
    }

    public String getExt1() 
    {
        return ext1;
    }

    public void setExt2(String ext2) 
    {
        this.ext2 = ext2;
    }

    public String getExt2() 
    {
        return ext2;
    }

    public void setExt3(String ext3) 
    {
        this.ext3 = ext3;
    }

    public String getExt3() 
    {
        return ext3;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("ID", getID())
            .append("ywid", getYwid())
            .append("fjmc", getFjmc())
            .append("fjdz", getFjdz())
            .append("mkmc", getMkmc())
            .append("fjlx", getFjlx())
            .append("fjhz", getFjhz())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("ext1", getExt1())
            .append("ext2", getExt2())
            .append("ext3", getExt3())
            .toString();
    }
}
