package com.ruoyi.project.ys.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.ys.mapper.YscgWjscqkMapper;
import com.ruoyi.project.ys.domain.YscgWjscqk;
import com.ruoyi.project.ys.service.IYscgWjscqkService;

/**
 * 成果管理Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@Service
public class YscgWjscqkServiceImpl implements IYscgWjscqkService 
{
    @Autowired
    private YscgWjscqkMapper yscgWjscqkMapper;

    /**
     * 查询成果管理
     * 
     * @param id 成果管理主键
     * @return 成果管理
     */
    @Override
    public YscgWjscqk selectYscgWjscqkById(Long id)
    {
        return yscgWjscqkMapper.selectYscgWjscqkById(id);
    }

    /**
     * 查询成果管理列表
     * 
     * @param yscgWjscqk 成果管理
     * @return 成果管理
     */
    @Override
    public List<YscgWjscqk> selectYscgWjscqkList(YscgWjscqk yscgWjscqk)
    {
        return yscgWjscqkMapper.selectYscgWjscqkList(yscgWjscqk);
    }

    /**
     * 新增成果管理
     * 
     * @param yscgWjscqk 成果管理
     * @return 结果
     */
    @Override
    public int insertYscgWjscqk(YscgWjscqk yscgWjscqk)
    {
        return yscgWjscqkMapper.insertYscgWjscqk(yscgWjscqk);
    }

    /**
     * 修改成果管理
     * 
     * @param yscgWjscqk 成果管理
     * @return 结果
     */
    @Override
    public int updateYscgWjscqk(YscgWjscqk yscgWjscqk)
    {
        yscgWjscqk.setUpdateTime(DateUtils.getNowDate());
        return yscgWjscqkMapper.updateYscgWjscqk(yscgWjscqk);
    }

    /**
     * 批量删除成果管理
     * 
     * @param ids 需要删除的成果管理主键
     * @return 结果
     */
    @Override
    public int deleteYscgWjscqkByIds(Long[] ids)
    {
        return yscgWjscqkMapper.deleteYscgWjscqkByIds(ids);
    }

    /**
     * 删除成果管理信息
     * 
     * @param id 成果管理主键
     * @return 结果
     */
    @Override
    public int deleteYscgWjscqkById(Long id)
    {
        return yscgWjscqkMapper.deleteYscgWjscqkById(id);
    }
}
