package com.ruoyi.project.ys.service.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.ruoyi.common.constant.Constants;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.framework.config.RuoYiConfig;
import com.ruoyi.project.dz.utils.SegyReadUtil;
import com.ruoyi.project.ys.domain.SegyZB;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.ys.mapper.YsqqXmxxSegyMapper;
import com.ruoyi.project.ys.domain.YsqqXmxxSegy;
import com.ruoyi.project.ys.service.IYsqqXmxxSegyService;

/**
 * segy信息Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@Service
public class YsqqXmxxSegyServiceImpl implements IYsqqXmxxSegyService 
{
    @Autowired
    private YsqqXmxxSegyMapper ysqqXmxxSegyMapper;

    /**
     * 查询segy信息
     * 
     * @param id segy信息主键
     * @return segy信息
     */
    @Override
    public YsqqXmxxSegy selectYsqqXmxxSegyById(Long id)
    {
        return ysqqXmxxSegyMapper.selectYsqqXmxxSegyById(id);
    }

    /**
     * 查询segy信息列表
     * 
     * @param ysqqXmxxSegy segy信息
     * @return segy信息
     */
    @Override
    public List<YsqqXmxxSegy> selectYsqqXmxxSegyList(YsqqXmxxSegy ysqqXmxxSegy)
    {
        return ysqqXmxxSegyMapper.selectYsqqXmxxSegyList(ysqqXmxxSegy);
    }

    /**
     * 新增segy信息
     * 
     * @param ysqqXmxxSegy segy信息
     * @return 结果
     */
    @Override
    public int insertYsqqXmxxSegy(YsqqXmxxSegy ysqqXmxxSegy)
    {
        // 新版segy路径
        String xbsegy = ysqqXmxxSegy.getXbsegy();
        // 本地资源路径
        String localPath = RuoYiConfig.getProfile();
        // 数据库资源地址
        String segyFilePath = localPath + StringUtils.substringAfter(xbsegy, Constants.RESOURCE_PREFIX);
        try {
            List<SegyZB> coordinates = SegyReadUtil.readCoordinates(segyFilePath);
            String result  = sampleAndConvertToJSON(coordinates, 20).toString();
            ysqqXmxxSegy.setX(result);
        } catch (IOException e) {
            e.printStackTrace();
        }
        int a = ysqqXmxxSegyMapper.insertYsqqXmxxSegy(ysqqXmxxSegy);
        return a;
    }



    /**
     * 修改segy信息
     * 
     * @param ysqqXmxxSegy segy信息
     * @return 结果
     */
    @Override
    public int updateYsqqXmxxSegy(YsqqXmxxSegy ysqqXmxxSegy)
    {
        ysqqXmxxSegy.setUpdateTime(DateUtils.getNowDate());


        // 新版segy路径
        String xbsegy = ysqqXmxxSegy.getXbsegy();
        // 本地资源路径
        String localPath = RuoYiConfig.getProfile();
        // 数据库资源地址
        String segyFilePath = localPath + StringUtils.substringAfter(xbsegy, Constants.RESOURCE_PREFIX);
        try {
            List<SegyZB> coordinates = SegyReadUtil.readCoordinates(segyFilePath);
            String result  = sampleAndConvertToJSON(coordinates, 20).toString();
            ysqqXmxxSegy.setX(result);
        } catch (IOException e) {
            e.printStackTrace();
        }
        int a = ysqqXmxxSegyMapper.updateYsqqXmxxSegy(ysqqXmxxSegy);
        return a;
    }

    /**
     * 从列表中均匀保留20个元素（包含首尾），并转换为JSONArray
     * @param originalList 原始SegyZB列表
     * @return 包含20个均匀分布元素的JSONArray
     */
    public static JSONArray sampleAndConvertToJSON(List<SegyZB> originalList, int keepCount) {
        JSONArray jsonArray = new JSONArray();

        if (originalList == null || originalList.isEmpty()) {
            return jsonArray;
        }

        // 若元素数量少于等于20，直接全部保留
        List<SegyZB> sampledList;
        if (originalList.size() <= keepCount) {
            sampledList = new ArrayList<>(originalList);
        } else {
            // 计算采样步长，确保首尾元素被选中
            int totalSize = originalList.size();
            double step = (totalSize - 1.0) / (keepCount - 1);
            sampledList = new ArrayList<>(keepCount);

            for (int i = 0; i < keepCount; i++) {
                // 计算当前索引（四舍五入取整）
                int index = (int) Math.round(i * step);
                // 确保索引不越界
                index = Math.min(index, totalSize - 1);
                sampledList.add(originalList.get(index));
            }
        }

        // 转换为JSONArray
        for (SegyZB item : sampledList) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("sxh", item.getSxh());
            jsonObj.put("x", item.getX());
            jsonObj.put("y", item.getY());
            jsonArray.add(jsonObj);
        }

        return jsonArray;
    }

    /**
     * 批量删除segy信息
     * 
     * @param ids 需要删除的segy信息主键
     * @return 结果
     */
    @Override
    public int deleteYsqqXmxxSegyByIds(Long[] ids)
    {
        return ysqqXmxxSegyMapper.deleteYsqqXmxxSegyByIds(ids);
    }

    /**
     * 删除segy信息信息
     * 
     * @param id segy信息主键
     * @return 结果
     */
    @Override
    public int deleteYsqqXmxxSegyById(Long id)
    {
        return ysqqXmxxSegyMapper.deleteYsqqXmxxSegyById(id);
    }
}
