package com.ruoyi.project.ys.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.ys.domain.Hyjyxx;
import com.ruoyi.project.ys.service.IHyjyxxService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import javax.annotation.Resource;

/**
 * 会议信息Controller
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@RestController
@RequestMapping("/hyjyxx/hyjyxx")
public class HyjyxxController extends BaseController
{
    @Autowired
    private IHyjyxxService hyjyxxService;

    /**
     * 查询会议信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(Hyjyxx hyjyxx)
    {
        startPage();
        List<Hyjyxx> list = hyjyxxService.selectHyjyxxList(hyjyxx);
        return getDataTable(list);
    }

    /**
     * 导出会议信息列表
     */
    @Log(title = "会议信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, Hyjyxx hyjyxx)
    {
        List<Hyjyxx> list = hyjyxxService.selectHyjyxxList(hyjyxx);
        ExcelUtil<Hyjyxx> util = new ExcelUtil<Hyjyxx>(Hyjyxx.class);
        util.exportExcel(response, list, "会议信息数据");
    }

    /**
     * 获取会议信息详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(hyjyxxService.selectHyjyxxById(id));
    }

    /**
     * 新增会议信息
     */
    @Log(title = "会议信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Hyjyxx hyjyxx)
    {
        return toAjax(hyjyxxService.insertHyjyxx(hyjyxx));
    }

    /**
     * 修改会议信息
     */
    @Log(title = "会议信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Hyjyxx hyjyxx)
    {
        return toAjax(hyjyxxService.updateHyjyxx(hyjyxx));
    }

    /**
     * 删除会议信息
     */
    @Log(title = "会议信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(hyjyxxService.deleteHyjyxxByIds(ids));
    }


    // 注入线程池
    @Resource
    private ThreadPoolTaskExecutor taskExecutor;
    /**
     * 会议转录
     */
    @Log(title = "会议转录", businessType = BusinessType.UPDATE)
    @PostMapping("/hyzl/{id}")
    public AjaxResult hyzl(@PathVariable("id") Long id)
    {
     /*   return toAjax(hyjyxxService.hyzl(id));*/

        // 提交任务到线程池异步执行
        taskExecutor.execute(() -> {
                hyjyxxService.hyzl(id);
        });

        // 立即返回，告知前端任务已启动
        return AjaxResult.success("会议转录任务已启动，请稍后查看结果");
    }

}
