package com.ruoyi.project.ys.mapper;

import java.util.List;
import com.ruoyi.project.ys.domain.CommunFile;

/**
 * 公用附件表Mapper接口
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
public interface CommunFileMapper 
{
    /**
     * 查询公用附件表
     * 
     * @param ID 公用附件表主键
     * @return 公用附件表
     */
    public CommunFile selectCommunFileByID(Long ID);

    /**
     * 查询公用附件表列表
     * 
     * @param communFile 公用附件表
     * @return 公用附件表集合
     */
    public List<CommunFile> selectCommunFileList(CommunFile communFile);

    /**
     * 新增公用附件表
     * 
     * @param communFile 公用附件表
     * @return 结果
     */
    public int insertCommunFile(CommunFile communFile);

    /**
     * 修改公用附件表
     * 
     * @param communFile 公用附件表
     * @return 结果
     */
    public int updateCommunFile(CommunFile communFile);

    /**
     * 删除公用附件表
     * 
     * @param ID 公用附件表主键
     * @return 结果
     */
    public int deleteCommunFileByID(Long ID);

    /**
     * 批量删除公用附件表
     * 
     * @param IDs 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteCommunFileByIDs(Long[] IDs);
}
