package com.ruoyi.project.ys.service.impl;

import java.util.ArrayList;
import java.util.List;

import com.github.pagehelper.Page;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.framework.web.page.PageDomain;
import com.ruoyi.framework.web.page.TableSupport;
import com.ruoyi.project.ys.domain.*;
import com.ruoyi.project.ys.mapper.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.ys.service.IYsqqXmxxService;
import org.springframework.util.CollectionUtils;

import static com.ruoyi.common.utils.SecurityUtils.getUserId;

/**
 * 验收前期-项目信息Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@Service
public class YsqqXmxxServiceImpl implements IYsqqXmxxService 
{
    @Autowired
    private YsqqXmxxMapper ysqqXmxxMapper;

    @Autowired
    private YsqqXmxxJxxMapper ysqqXmxxJxxMapper;
    @Autowired
    private YsqqXmxxSegyMapper ysqqXmxxSegyMapper;


    @Autowired
    private YsqqXmxxSegydzMapper ysqqXmxxSegydzMapper;

    /**
     * 查询验收前期-项目信息
     * 
     * @param id 验收前期-项目信息主键
     * @return 验收前期-项目信息
     */
    @Override
    public YsqqXmxx selectYsqqXmxxById(Long id)
    {
        YsqqXmxx  ysqqXmxx=  ysqqXmxxMapper.selectYsqqXmxxById(id);
        return ysqqXmxx;
    }

    /**
     * 查询验收前期-项目信息列表
     * 
     * @param ysqqXmxx 验收前期-项目信息
     * @return 验收前期-项目信息
     */
    @Override
    public List<YsqqXmxx> selectYsqqXmxxList(YsqqXmxx ysqqXmxx)
    {
        return ysqqXmxxMapper.selectYsqqXmxxList(ysqqXmxx);
    }

    /**
     * 新增验收前期-项目信息
     * 
     * @param ysqqXmxx 验收前期-项目信息
     * @return 结果
     */
    @Override
    public int insertYsqqXmxx(YsqqXmxx ysqqXmxx)
    {
        ysqqXmxx.setCreatedBy(getUserId()+"");
        ysqqXmxx.setCreatedTime(DateUtils.getNowDate());
        return ysqqXmxxMapper.insertYsqqXmxx(ysqqXmxx);
    }

    /**
     * 修改验收前期-项目信息
     * 
     * @param ysqqXmxx 验收前期-项目信息
     * @return 结果
     */
    @Override
    public int updateYsqqXmxx(YsqqXmxx ysqqXmxx)
    {
        ysqqXmxx.setUpdateBy(getUserId()+"");
        ysqqXmxx.setUpdateTime(DateUtils.getNowDate());
        return ysqqXmxxMapper.updateYsqqXmxx(ysqqXmxx);
    }

    /**
     * 批量删除验收前期-项目信息
     * 
     * @param ids 需要删除的验收前期-项目信息主键
     * @return 结果
     */
    @Override
    public int deleteYsqqXmxxByIds(Long[] ids)
    {
        return ysqqXmxxMapper.deleteYsqqXmxxByIds(ids);
    }

    /**
     * 删除验收前期-项目信息信息
     * 
     * @param id 验收前期-项目信息主键
     * @return 结果
     */
    @Override
    public int deleteYsqqXmxxById(Long id)
    {
        return ysqqXmxxMapper.deleteYsqqXmxxById(id);
    }

    /**
     * 查询验收前期-项目信息
     *
     * @param id 验收前期-项目信息主键
     * @return 验收前期-项目信息
     */
    @Override
    public YsqqXmxx selectYsqqXmxxById_XQ(Long id)
    {
        YsqqXmxx  ysqqXmxx=  ysqqXmxxMapper.selectYsqqXmxxById(id);
        // 井信息
        YsqqXmxxJxx ysqqXmxxJxx = new YsqqXmxxJxx();
        ysqqXmxxJxx.setZbid(id);
        List<YsqqXmxxJxx>  jwxxList = ysqqXmxxJxxMapper.selectYsqqXmxxJxxList(ysqqXmxxJxx);
        ysqqXmxx.setYsqqXmxxJxxList(jwxxList);
        // 井信息，区块信息
        YsqqXmxxSegy ysqqXmxxSegy = new YsqqXmxxSegy();
        ysqqXmxxSegy.setZbid(id);
        List<YsqqXmxxSegy> segyList = ysqqXmxxSegyMapper.selectYsqqXmxxSegyList(ysqqXmxxSegy);
        YsqqXmxxSegydz ysqqXmxxSegydz = new YsqqXmxxSegydz();
        ysqqXmxxSegydz.setXmid(id);
        List<YsqqXmxxSegydz> ysqqXmxxSegydzs = ysqqXmxxSegydzMapper.selectYsqqXmxxSegydzList(ysqqXmxxSegydz);
        for(YsqqXmxxSegy segy: segyList){
            //查询旧版
            YsqqXmxxSegydz jb = ysqqXmxxSegydzs.stream().filter(dz -> dz.getSegyid().toString().equals(segy.getId().toString()) && dz.getLx().equals("旧版")).findFirst().orElse(null);
            if(jb != null){
                segy.setJbbznr(jb.getBznr());
            }
            //查询新版
            YsqqXmxxSegydz xb = ysqqXmxxSegydzs.stream().filter(dz -> dz.getSegyid().toString().equals(segy.getId().toString()) && dz.getLx().equals("新版")).findFirst().orElse(null);
            if(xb != null){
                segy.setXbbznr(xb.getBznr());
            }

        }

        ysqqXmxx.setYsqqXmxxSegy(segyList);
        return ysqqXmxx;
    }

    @Autowired
    private YscgZllxMapper yscgZllxMapper;
    @Autowired
    private YscgWjscqkMapper yscgWjscqkMapper;

    @Override
    public List<YsqqXmxx> yscgList(YsqqXmxx ysqqXmxx)
    {
        //项目信息
        Page<YsqqXmxx> xmxxList  = (Page<YsqqXmxx>)ysqqXmxxMapper.selectYsqqXmxxList(ysqqXmxx);
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        Integer PXH = (pageNum-1)*pageSize;
        // 资料类型
        YscgZllx yscgZllx = new YscgZllx();
        List<YscgZllx>  zllxList = yscgZllxMapper.selectYscgZllxList(yscgZllx);

        // 资料上传情况 上传数量
        YscgWjscqk yscgWjscqk = new YscgWjscqk();
        List<YscgWjscqk>    zlscList = yscgWjscqkMapper.selectYscgWjscqkList(yscgWjscqk);

        Page<YsqqXmxx> jctzList =  new Page<>();
        for (YsqqXmxx item1 : xmxxList) {
            PXH++;
            for (YscgZllx item2 : zllxList) {
                YsqqXmxx xmxx = new YsqqXmxx();
                xmxx.setId(item1.getId());
                xmxx.setXmmc(item1.getXmmc());
                xmxx.setXmzt(item1.getXmzt());
                xmxx.setQk(item1.getQk());
                xmxx.setCyids(item1.getCyids());
                xmxx.setXmjss(item1.getXmjss());
                xmxx.setCreatedBy(item1.getCreatedBy());

                xmxx.setPxh(PXH);
                xmxx.setZllxid(item2.getId());
                xmxx.setZllxmc(item2.getLxmc());

                jctzList.add(xmxx);
            }
        }
        for (YsqqXmxx item3 : jctzList) {
            String  zllxmc =item3.getZllxmc();
            Long  xmid = item3.getId();
            long count = zlscList.stream()
                    // 过滤出xmid和zllx都匹配的记录
                    .filter(zlsc -> xmid.equals(zlsc.getXmid()) && zllxmc.equals(zlsc.getZllx()))
                    // 统计数量
                    .count();
            item3.setZlsl((int) count);
        }
        jctzList.setTotal(CollectionUtils.isEmpty(xmxxList) ? 0 : xmxxList.getTotal());
        jctzList.setPageNum(pageNum);
        jctzList.setPageSize(pageSize);
        return  jctzList;
    }
}
