package com.ruoyi.project.ys.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.ys.mapper.YsqqXmxxSegydzMapper;
import com.ruoyi.project.ys.domain.YsqqXmxxSegydz;
import com.ruoyi.project.ys.service.IYsqqXmxxSegydzService;

/**
 * segy文件标注Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@Service
public class YsqqXmxxSegydzServiceImpl implements IYsqqXmxxSegydzService 
{
    @Autowired
    private YsqqXmxxSegydzMapper ysqqXmxxSegydzMapper;

    /**
     * 查询segy文件标注
     * 
     * @param id segy文件标注主键
     * @return segy文件标注
     */
    @Override
    public YsqqXmxxSegydz selectYsqqXmxxSegydzById(Long id)
    {
        return ysqqXmxxSegydzMapper.selectYsqqXmxxSegydzById(id);
    }

    /**
     * 查询segy文件标注列表
     * 
     * @param ysqqXmxxSegydz segy文件标注
     * @return segy文件标注
     */
    @Override
    public List<YsqqXmxxSegydz> selectYsqqXmxxSegydzList(YsqqXmxxSegydz ysqqXmxxSegydz)
    {
        return ysqqXmxxSegydzMapper.selectYsqqXmxxSegydzList(ysqqXmxxSegydz);
    }

    /**
     * 新增segy文件标注
     * 
     * @param ysqqXmxxSegydz segy文件标注
     * @return 结果
     */
    @Override
    public int insertYsqqXmxxSegydz(YsqqXmxxSegydz ysqqXmxxSegydz)
    {
        return ysqqXmxxSegydzMapper.insertYsqqXmxxSegydz(ysqqXmxxSegydz);
    }

    /**
     * 修改segy文件标注
     * 
     * @param ysqqXmxxSegydz segy文件标注
     * @return 结果
     */
    @Override
    public int updateYsqqXmxxSegydz(YsqqXmxxSegydz ysqqXmxxSegydz)
    {
        ysqqXmxxSegydz.setUpdateTime(DateUtils.getNowDate());
        return ysqqXmxxSegydzMapper.updateYsqqXmxxSegydz(ysqqXmxxSegydz);
    }

    /**
     * 批量删除segy文件标注
     * 
     * @param ids 需要删除的segy文件标注主键
     * @return 结果
     */
    @Override
    public int deleteYsqqXmxxSegydzByIds(Long[] ids)
    {
        return ysqqXmxxSegydzMapper.deleteYsqqXmxxSegydzByIds(ids);
    }

    /**
     * 删除segy文件标注信息
     * 
     * @param id segy文件标注主键
     * @return 结果
     */
    @Override
    public int deleteYsqqXmxxSegydzById(Long id)
    {
        return ysqqXmxxSegydzMapper.deleteYsqqXmxxSegydzById(id);
    }

    @Override
    public int addAll(YsqqXmxxSegydz ysqqXmxxSegydz) {
        List<YsqqXmxxSegydz> list = ysqqXmxxSegydz.getList();
        //删除旧数据
        ysqqXmxxSegydzMapper.deleteYsqqXmxxSegydzBySegyId(list.get(0).getSegyid());

        return ysqqXmxxSegydzMapper.insertYsqqXmxxSegydzBatch(list);
    }
}
