package com.ruoyi.project.ys.service;

import java.util.List;
import com.ruoyi.project.ys.domain.YscgFileRole;

/**
 * 成果单文件权限管理Service接口
 * 
 * @author ruoyi
 * @date 2025-10-31
 */
public interface IYscgFileRoleService 
{
    /**
     * 查询成果单文件权限管理
     * 
     * @param id 成果单文件权限管理主键
     * @return 成果单文件权限管理
     */
    public YscgFileRole selectYscgFileRoleById(Long id);

    /**
     * 查询成果单文件权限管理列表
     * 
     * @param yscgFileRole 成果单文件权限管理
     * @return 成果单文件权限管理集合
     */
    public List<YscgFileRole> selectYscgFileRoleList(YscgFileRole yscgFileRole);

    /**
     * 新增成果单文件权限管理
     * 
     * @param yscgFileRole 成果单文件权限管理
     * @return 结果
     */
    public int insertYscgFileRole(YscgFileRole yscgFileRole);

    /**
     * 修改成果单文件权限管理
     * 
     * @param yscgFileRole 成果单文件权限管理
     * @return 结果
     */
    public int updateYscgFileRole(YscgFileRole yscgFileRole);

    /**
     * 批量删除成果单文件权限管理
     * 
     * @param ids 需要删除的成果单文件权限管理主键集合
     * @return 结果
     */
    public int deleteYscgFileRoleByIds(Long[] ids);

    /**
     * 删除成果单文件权限管理信息
     * 
     * @param id 成果单文件权限管理主键
     * @return 结果
     */
    public int deleteYscgFileRoleById(Long id);

    public int batchYscgFileRole(Long fileid, Long[] userIds);
}
