package com.ruoyi.project.ys.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.framework.aspectj.lang.annotation.DataSource;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * segy文件标注对象 ysqq_xmxx_segydz
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@Data
public class YsqqXmxxSegydz extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 项目idid */
    @Excel(name = "项目idid")
    private Long xmid;

    /** segyid */
    @Excel(name = "segyid")
    private Long segyid;

    /** 类型（新版、旧版） */
    @Excel(name = "类型", readConverterExp = "新=版、旧版")
    private String lx;

    /** 标注内容 */
    @Excel(name = "标注内容")
    private String bznr;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    /** 备用1 */
    @Excel(name = "备用1")
    private String ext1;

    /** 备用2 */
    @Excel(name = "备用2")
    private String ext2;

    /** 备用3 */
    @Excel(name = "备用3")
    private String ext3;

    private List<YsqqXmxxSegydz> list =new ArrayList<>();

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setXmid(Long xmid) 
    {
        this.xmid = xmid;
    }

    public Long getXmid() 
    {
        return xmid;
    }

    public void setSegyid(Long segyid) 
    {
        this.segyid = segyid;
    }

    public Long getSegyid() 
    {
        return segyid;
    }

    public void setLx(String lx) 
    {
        this.lx = lx;
    }

    public String getLx() 
    {
        return lx;
    }

    public void setBznr(String bznr) 
    {
        this.bznr = bznr;
    }

    public String getBznr() 
    {
        return bznr;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    public void setExt1(String ext1) 
    {
        this.ext1 = ext1;
    }

    public String getExt1() 
    {
        return ext1;
    }

    public void setExt2(String ext2) 
    {
        this.ext2 = ext2;
    }

    public String getExt2() 
    {
        return ext2;
    }

    public void setExt3(String ext3) 
    {
        this.ext3 = ext3;
    }

    public String getExt3() 
    {
        return ext3;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("xmid", getXmid())
            .append("segyid", getSegyid())
            .append("lx", getLx())
            .append("bznr", getBznr())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("ext1", getExt1())
            .append("ext2", getExt2())
            .append("ext3", getExt3())
            .toString();
    }
}
