package com.ruoyi.project.ys.utils;

/**
 * Created by wangjian on 2023/9/4.
 */
public class roleUtil {

    /**
     * 根据目标cyid（String类型）获取对应的xmjs值
     * @param cyids 逗号分隔的cyid字符串（可能为null）
     * @param xmjss 逗号分隔的xmjs字符串
     * @param targetCyid 目标cyid（String类型）
     * @return 对应的xmjs值，或提示信息
     */
    public static String getXmjsByCyid(String cyids, String xmjss, String targetCyid) {
        // 处理null和空字符串情况
        if (cyids == null || cyids.trim().isEmpty()) {
            return "查看者";
        }
        if (xmjss == null || xmjss.trim().isEmpty()) {
            return "查看者";
        }
        if (targetCyid == null || targetCyid.trim().isEmpty()) {
            return "查看者";
        }

        // 去除目标cyid的前后空格
        String trimmedTarget = targetCyid.trim();

        // 拆分字符串为数组
        String[] cyidArray = cyids.split(",");
        String[] xmjsArray = xmjss.split(",");

        // 校验数组长度是否一致
        if (cyidArray.length != xmjsArray.length) {
            return "查看者";
        }

        // 查找目标cyid对应的xmjs（字符串直接比较）
        for (int i = 0; i < cyidArray.length; i++) {
            // 去除当前cyid的前后空格后再比较
            if (cyidArray[i].trim().equals(trimmedTarget)) {
                return xmjsArray[i].trim();
            }
        }

        // 未找到对应记录
        return "查看者";
    }


}
