package com.ruoyi.project.dz.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 获取两坐标之间的坐标点
 * Created by wangjian on 2023/9/1.
 */
public class CoordinateUtil {

    /**
     * 依次传入两个点的XY坐标 返回两点之间的点列表
     * */
    public static List<Point> getPointBetweenTwo(int startX, int startY, int endX, int endY){
        //目前可以处理 第二个点在第一个点右上、正右、正上、右下、
        //不行的 正下、左下、正左、左上

        //步骤1：获取起始坐标和结束坐标
//        int startX = 10;
//        int startY = 10;
//        int endX = 10;
//        int endY = 2;

        //步骤2：计算两坐标之间的水平和垂直距离
        int horizontalDistance = endX - startX;
        int verticalDistance = endY - startY;

        //步骤3：根据水平和垂直距离计算每一步的增量
        //根据水平和垂直距离计算每一步的增量。增量可以通过将水平距离除以最大步数得到，
        //同样地，垂直增量可以通过将垂直距离除以最大步数得到。为了简化，我们假设步数为10。
        int maxSteps = horizontalDistance == 0 ? verticalDistance:horizontalDistance;//X轴坐标变化为0时，用Y计算
        int abs_maxSteps = Math.abs(maxSteps);//绝对值 解决 第二个点在第一个点的 正下、左下、正左、左上 的情况
        double horizontalIncrement = (double)horizontalDistance / abs_maxSteps;
        double verticalIncrement = (double)verticalDistance / abs_maxSteps;

        //步骤4：通过增量依次计算并输出每一个坐标点
        List<Point> lp = new ArrayList<>();
        for (int i = 0; i <= abs_maxSteps; i++) {
            double currentX = startX + (i * horizontalIncrement);
            double currentY = startY + (i * verticalIncrement);
            Double bx = new BigDecimal(currentX).setScale(0, BigDecimal.ROUND_HALF_UP).doubleValue();
            Double by = new BigDecimal(currentY).setScale(0, BigDecimal.ROUND_HALF_UP).doubleValue();
            //System.out.println("坐标点 " + i + ": (" + bx + ", " + by + ")");
            Point p = new Point();
            p.setX(bx.intValue());
            p.setY(by.intValue());
            lp.add(p);
        }
        return lp;
    }
}
