package com.ruoyi.project.ys.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.ys.mapper.YsqqXmxxMapper;
import com.ruoyi.project.ys.domain.YsqqXmxx;
import com.ruoyi.project.ys.service.IYsqqXmxxService;

/**
 * 验收前期-项目信息Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@Service
public class YsqqXmxxServiceImpl implements IYsqqXmxxService 
{
    @Autowired
    private YsqqXmxxMapper ysqqXmxxMapper;

    /**
     * 查询验收前期-项目信息
     * 
     * @param id 验收前期-项目信息主键
     * @return 验收前期-项目信息
     */
    @Override
    public YsqqXmxx selectYsqqXmxxById(Long id)
    {
        return ysqqXmxxMapper.selectYsqqXmxxById(id);
    }

    /**
     * 查询验收前期-项目信息列表
     * 
     * @param ysqqXmxx 验收前期-项目信息
     * @return 验收前期-项目信息
     */
    @Override
    public List<YsqqXmxx> selectYsqqXmxxList(YsqqXmxx ysqqXmxx)
    {
        return ysqqXmxxMapper.selectYsqqXmxxList(ysqqXmxx);
    }

    /**
     * 新增验收前期-项目信息
     * 
     * @param ysqqXmxx 验收前期-项目信息
     * @return 结果
     */
    @Override
    public int insertYsqqXmxx(YsqqXmxx ysqqXmxx)
    {
        return ysqqXmxxMapper.insertYsqqXmxx(ysqqXmxx);
    }

    /**
     * 修改验收前期-项目信息
     * 
     * @param ysqqXmxx 验收前期-项目信息
     * @return 结果
     */
    @Override
    public int updateYsqqXmxx(YsqqXmxx ysqqXmxx)
    {
        ysqqXmxx.setUpdateTime(DateUtils.getNowDate());
        return ysqqXmxxMapper.updateYsqqXmxx(ysqqXmxx);
    }

    /**
     * 批量删除验收前期-项目信息
     * 
     * @param ids 需要删除的验收前期-项目信息主键
     * @return 结果
     */
    @Override
    public int deleteYsqqXmxxByIds(Long[] ids)
    {
        return ysqqXmxxMapper.deleteYsqqXmxxByIds(ids);
    }

    /**
     * 删除验收前期-项目信息信息
     * 
     * @param id 验收前期-项目信息主键
     * @return 结果
     */
    @Override
    public int deleteYsqqXmxxById(Long id)
    {
        return ysqqXmxxMapper.deleteYsqqXmxxById(id);
    }
}
