package com.ruoyi.project.ys.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.ys.domain.YsqqXmxxSegy;
import com.ruoyi.project.ys.service.IYsqqXmxxSegyService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * segy信息Controller
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@RestController
@RequestMapping("/ysqqXmxxSegy/segy")
public class YsqqXmxxSegyController extends BaseController
{
    @Autowired
    private IYsqqXmxxSegyService ysqqXmxxSegyService;

    /**
     * 查询segy信息列表
     */
    @PreAuthorize("@ss.hasPermi('ysqqXmxxSegy:segy:list')")
    @GetMapping("/list")
    public TableDataInfo list(YsqqXmxxSegy ysqqXmxxSegy)
    {
        startPage();
        List<YsqqXmxxSegy> list = ysqqXmxxSegyService.selectYsqqXmxxSegyList(ysqqXmxxSegy);
        return getDataTable(list);
    }

    /**
     * 导出segy信息列表
     */
    @PreAuthorize("@ss.hasPermi('ysqqXmxxSegy:segy:export')")
    @Log(title = "segy信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, YsqqXmxxSegy ysqqXmxxSegy)
    {
        List<YsqqXmxxSegy> list = ysqqXmxxSegyService.selectYsqqXmxxSegyList(ysqqXmxxSegy);
        ExcelUtil<YsqqXmxxSegy> util = new ExcelUtil<YsqqXmxxSegy>(YsqqXmxxSegy.class);
        util.exportExcel(response, list, "segy信息数据");
    }

    /**
     * 获取segy信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('ysqqXmxxSegy:segy:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(ysqqXmxxSegyService.selectYsqqXmxxSegyById(id));
    }

    /**
     * 新增segy信息
     */
    @PreAuthorize("@ss.hasPermi('ysqqXmxxSegy:segy:add')")
    @Log(title = "segy信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody YsqqXmxxSegy ysqqXmxxSegy)
    {
        return toAjax(ysqqXmxxSegyService.insertYsqqXmxxSegy(ysqqXmxxSegy));
    }

    /**
     * 修改segy信息
     */
    @PreAuthorize("@ss.hasPermi('ysqqXmxxSegy:segy:edit')")
    @Log(title = "segy信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody YsqqXmxxSegy ysqqXmxxSegy)
    {
        return toAjax(ysqqXmxxSegyService.updateYsqqXmxxSegy(ysqqXmxxSegy));
    }

    /**
     * 删除segy信息
     */
    @PreAuthorize("@ss.hasPermi('ysqqXmxxSegy:segy:remove')")
    @Log(title = "segy信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(ysqqXmxxSegyService.deleteYsqqXmxxSegyByIds(ids));
    }
}
