package com.ruoyi.project.dz.utils;


/**
 * 表2. 二进制文件头
400字节二进制文件头
字节	描述
3201-3204	作业标识号
3205-3208	测线号。对3-D叠后数据而言，它将典型地包含纵向测线（In-line）号
3209-3212	卷号
3213-32145	每个道集的数据道数。叠前数据强制要求
3215-32165	每个道集的辅助道数。叠前数据强制要求
3217-32186	微秒（us）形式的采样间隔。叠前数据强制要求
 3219-3220	微秒（us）形式的原始野外记录采样间隔
3221-32226	数据道采样点数。叠前数据强制要求
注释：二进制文件头中的采样间隔和采样点数应当是文件中地震数据的首要一组参数
3223-3224	原始野外记录每道采样点数
3225-32266	数据采样格式编码。叠前数据强制要求
1＝4字节IBM浮点数
2＝4字节，两互补整数
3＝2字节，两互补整数
4＝4字节带增益定点数（过时，不再使用）
5＝4字节IEEE浮点数
6＝现在没有使用
7＝现在没有使用
8＝1字节，两互补整数
3227-32287	道集覆盖次数――每个数据集的期望数据道数（例如CMP覆盖次数）。强烈推荐所有类型的数据使用
3229-32307	道分选码（即集合类型）：
-1＝其他（应在用户扩展文件头文本段中解释）
0＝未知
1＝同记录（未分选）
2＝CDP道集
3＝单次覆盖连续剖面
4＝水平叠加
5＝共炮点
6＝共接收点
7＝共偏移距
8＝共中心点
9＝共转换点
强烈推荐所有类型的数据使用
3231-3232	垂直求和码：
1＝不求和
2＝两次求和
…
M=M-1求和（M＝2到32767）
3233-3234	起始扫描频率（Hz）
3235-3236	终止扫描频率（Hz）
3237-3238	扫描长度（ms）
3239-3240	扫描类型码：
1＝线性
2＝抛物线
3＝指数
4＝其他
3241-3242	扫描信道的道数
3243-3244	有斜坡时，以毫秒表示的扫描道起始斜坡长度（斜坡从零时刻开始，对这个长度有效）
3245-3246	以毫秒表示的扫描道终止斜坡长度（斜坡终止始于扫描长度减去斜坡结尾处的长度）
3247-3248	斜坡类型：
1＝线性
2＝cos2
3=其他
3249-3250	相关数据道：
1＝无相关
2＝相关
3251-3252	二进制增益恢复：
1＝恢复
2＝未恢复
3253-3254	振幅恢复方法：
1＝无
2＝球面扩散
3＝自动增益控制
4＝其他
3255-32567	测量系统：强烈推荐所有类型的数据使用。如文件中包含位置数据文本段，这条必须与位置数据文本段一致。如不同，最后位置数据文本段有控制权。
1＝米
2＝英尺
3257-3258	脉冲极化码：
1＝压力增大或检波器向上运动在磁带上记作负数
2＝压力减小或检波器向下运动在磁带上记作正数
3259-3260	可控源极化码：
地震信号滞后引导信号：
1＝337.5°-22.5°
2＝22.5°-67.5°
3＝67.5°-112.5°
4＝112.5°-157.5°
5＝157.5°-202.5°
6＝202.5°-247.5°
7＝247.5°-292.5°
8＝292.5°-337.5°
3261-3500	未赋值
3501-3502 6	SEG Y格式修订版号。这是一个16比特无符号数值，在第一和第二字节间有Q点。例如SEG Y修订版1.0，如文档定义，它将记录为0100 。此字段对所有SEG Y版本强制要求，尽管零值表示遵从1975年标准的“传统”SEG Y
3503-3504 6	固定长度道标志。1表示SEG Y文件中所有道确保具有相同的采样间隔和采样点数，即在原文文件头中3217-3218和3221-3222字节。0表示文件中的道长可能变化，此时道头中115-116字节的采样点数必须用来确认各道的实际长度。此字段对所有SEG Y版本强制要求，尽管零值表示遵从1975年标准的“传统”SEG Y
3505-3506 6	3200字节扩展原文文件头记录在二进制头后。0表示没有扩展原文文件头记录（即此文件无扩展原文文件头）。-1表示扩展原文文件头记录数可变，并且扩展原文文件头结尾用最终记录的一个文本段((SEG: ENDText))表示。正值表示有很多原文文件头。注意虽然具体的扩展原文文件头数目是个有用的信息，但是在写二进制头时它并不是总知道也不是强制要求在此记录正值。此字段对所有SEG Y版本强制要求，尽管零值表示遵从1975年标准的“传统”SEG Y
3507-3600	未赋值
 
5 此信息对叠前数据强制要求。
6 此信息对所有数据类型强制要求。
7 强烈建议此信息一直被记录。

 * @author dingyi
 *
 */
public class SegyReelHdr {
	// 3201-3204 作业标识号
	int job_id_number;

	// 3205-3208 测线号。对3-D叠后数据而言，它将典型地包含纵向测线（In-line）号
	int line_number;

	// 3209-3212 卷号
	int reel_number;

	// 3213-3214 每个道集的数据道数。叠前数据强制要求
	short traces_per_record;

	// 3215-3216 每个道集的辅助道数。叠前数据强制要求
	short aux_traces_per_record;

	// 3217-3218 微秒（us）形式的采样间隔。叠前数据强制要求
	short sample_data_interval_ms;

	// 3219-3220 微秒（us）形式的原始野外记录采样间隔
	short original_data_interval_ms;

	// 3221-3222 数据道采样点数。叠前数据强制要求
	// 注释：二进制文件头中的采样间隔和采样点数应当是文件中地震数据的首要一组参数
	short samples_per_trace;

	// 3223-3224 原始野外记录每道采样点数
	short original_samples_per_trace;

	// 3225-3226 数据采样格式编码。叠前数据强制要求
	/**
	 * 1＝4字节IBM浮点数 2＝4字节，两互补整数 3＝2字节，两互补整数 4＝4字节带增益定点数（过时，不再使用） 5＝4字节IEEE浮点数
	 * 6＝现在没有使用 7＝现在没有使用 8＝1字节，两互补整数
	 */
	short data_sample_format_code;// 数据采样格式编码

	// 3227-32287 道集覆盖次数――每个数据集的期望数据道数（例如CMP覆盖次数）。强烈推荐所有类型的数据使用
	short CDP_fold;

	// 3229-32307 道分选码（即集合类型）：
	/**
	 * -1＝其他（应在用户扩展文件头文本段中解释） 0＝未知 1＝同记录（未分选） 2＝CDP道集 3＝单次覆盖连续剖面 4＝水平叠加 5＝共炮点
	 * 6＝共接收点 7＝共偏移距 8＝共中心点 9＝共转换点 强烈推荐所有类型的数据使用
	 */
	short trace_sorting_code;// 3229-32307 道分选码（即集合类型）：

	// 3231-3232 垂直求和码：
	/*
	 * 1＝不求和 2＝两次求和 … M=M-1求和（M＝2到32767）
	 */
	short vertical_sum_code;

	// 3233-3234 起始扫描频率（Hz）
	short sweep_frequency_start_hz;

	// 3235-3236 终止扫描频率（Hz）
	short sweep_frequency_end_hz;

	// 3237-3238 扫描长度（ms）
	short sweep_length_ms;

	// 3239-3240 扫描类型码：
	/**
	 * 1＝线性 2＝抛物线 3＝指数 4＝其他
	 */
	short sweep_type_code;

	// 3241-3242 扫描信道的道数
	short trace_number_of_sweep_channel;

	// 3243-3244 有斜坡时，以毫秒表示的扫描道起始斜坡长度（斜坡从零时刻开始，对这个长度有效）
	short sweep_trace_taper_length_start_ms;

	// 3245-3246 以毫秒表示的扫描道终止斜坡长度（斜坡终止始于扫描长度减去斜坡结尾处的长度）
	short sweep_trace_taper_length_end_ms;

	/**
	 * 3247-3248 斜坡类型： 1＝线性 2＝cos2 3=其他
	 */
	short taper_type_code;

	// 3249-3250 相关数据道：
	// 1＝无相关
	// 2＝相关
	short correlated_data_traces_flag;

	/**
	 * 3251-3252 二进制增益恢复： 1＝恢复 2＝未恢复
	 **/
	short binary_gain_recovered_flag;

	/**
	 * 3253-3254 振幅恢复方法： 1＝无 2＝球面扩散 3＝自动增益控制 4＝其他*
	 */
	short amplitude_recovery_method_code;

	/**
	 * 3255-32567
	 * 测量系统：强烈推荐所有类型的数据使用。如文件中包含位置数据文本段，这条必须与位置数据文本段一致。如不同，最后位置数据文本段有控制权。 1＝米
	 * 2＝英尺
	 **/
	short measurement_system;

	/**
	 * 3257-3258 脉冲极化码： 1＝压力增大或检波器向上运动在磁带上记作负数 2＝压力减小或检波器向下运动在磁带上记作正数
	 **/
	short impulse_signal_polarity;

	/**
	 * 3259-3260 可控源极化码： 地震信号滞后引导信号： 1＝337.5°-22.5° 2＝22.5°-67.5° 3＝67.5°-112.5°
	 * 4＝112.5°-157.5° 5＝157.5°-202.5° 6＝202.5°-247.5° 7＝247.5°-292.5°
	 * 8＝292.5°-337.5°
	 **/
	short vibratory_polarity_code;

	// 3261-3500 未赋值
	// 3501-3502 6 SEG Y格式修订版号。这是一个16比特无符号数值，在第一和第二字节间有Q点。例如SEG
	// Y修订版1.0，如文档定义，它将记录为0100 。此字段对所有SEG Y版本强制要求，尽管零值表示遵从1975年标准的“传统”SEG Y
	short segy_version;
	// 3503-3504 6 固定长度道标志。1表示SEG
	// Y文件中所有道确保具有相同的采样间隔和采样点数，即在原文文件头中3217-3218和3221-3222字节。0表示文件中的道长可能变化，此时道头中115-116字节的采样点数必须用来确认各道的实际长度。此字段对所有SEG
	// Y版本强制要求，尽管零值表示遵从1975年标准的“传统”SEG Y
	short fix_length_trace_flag;
	// 3505-3506 6
	// 3200字节扩展原文文件头记录在二进制头后。0表示没有扩展原文文件头记录（即此文件无扩展原文文件头）。-1表示扩展原文文件头记录数可变，并且扩展原文文件头结尾用最终记录的一个文本段((SEG:
	// ENDText))表示。正值表示有很多原文文件头。注意虽然具体的扩展原文文件头数目是个有用的信息，但是在写二进制头时它并不是总知道也不是强制要求在此记录正值。此字段对所有SEG
	// Y版本强制要求，尽管零值表示遵从1975年标准的“传统”SEG Y
	short has_extend_text_hdr_flag;// 如果不为0，则有扩展的3200个标头

	// 3507-3600 未赋值

	public SegyReelHdr(byte[] b) {
		int i = 0;
		job_id_number = b[i + 3] & 0xff | (b[i + 2] << 8 & 0xff00)
				| (b[i + 1] << 16 & 0xff0000) | (b[i] << 24 & 0xff000000);
		i = 4;
		line_number = b[i + 3] & 0xff | (b[i + 2] << 8 & 0xff00)
				| (b[i + 1] << 16 & 0xff0000) | (b[i] << 24 & 0xff000000);
		i = 8;
		reel_number = b[i + 3] & 0xff | (b[i + 2] << 8 & 0xff00)
				| (b[i + 1] << 16 & 0xff0000) | (b[i] << 24 & 0xff000000);
		i = 12;
		traces_per_record = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 14;
		aux_traces_per_record = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 16;
		sample_data_interval_ms = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 18;
		original_data_interval_ms = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 20;
		samples_per_trace = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 22;
		original_samples_per_trace = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 24;
		data_sample_format_code = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 26;
		CDP_fold = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 28;
		trace_sorting_code = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 30;
		vertical_sum_code = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 32;
		sweep_frequency_start_hz = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 34;
		sweep_frequency_end_hz = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 36;
		sweep_length_ms = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 38;
		sweep_type_code = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 40;
		trace_number_of_sweep_channel = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 42;
		sweep_trace_taper_length_start_ms = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 44;
		sweep_trace_taper_length_end_ms = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 46;
		taper_type_code = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 48;
		correlated_data_traces_flag = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 50;
		binary_gain_recovered_flag = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 52;
		amplitude_recovery_method_code = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 54;
		measurement_system = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 56;
		impulse_signal_polarity = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 58;
		vibratory_polarity_code = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		// 3261-3500 未赋值
		i = 300;
		segy_version = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 302;
		fix_length_trace_flag = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		i = 304;
		has_extend_text_hdr_flag = (short) ((b[i + 1] & 0xff | (b[i] << 8 & 0xff00)));
		// 3507-3600 未赋值
	}


	/**
	 * 得到编码格式对应的倍数
	 * 依据2002年segy数据规范
	 * 
	 * 1＝4字节IBM浮点数 2＝4字节，两互补整数 3＝2字节，两互补整数 4＝4字节带增益定点数（过时，不再使用） 5＝4字节IEEE浮点数
	 * 6＝现在没有使用 7＝现在没有使用 8＝1字节，两互补整数
	 */

	public int getMultiple() throws SegyFileFormatException {
		switch (this.data_sample_format_code) {
		case 1:
		case 2:
		case 4:
		case 5:
			return 4;
		case 3:
			return 2;
		case 8:
			return 1;
		}
		throw new SegyFileFormatException("编码类型参数错误");
	}

}
