package com.ruoyi.project.ys.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.ys.domain.HyjyxxFile;
import com.ruoyi.project.ys.service.IHyjyxxFileService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 会议纪要_附件Controller
 * 
 * @author ruoyi
 * @date 2025-11-03
 */
@RestController
@RequestMapping("/hyjyxxFile/file")
public class HyjyxxFileController extends BaseController
{
    @Autowired
    private IHyjyxxFileService hyjyxxFileService;

    /**
     * 查询会议纪要_附件列表
     */
    @GetMapping("/list")
    public TableDataInfo list(HyjyxxFile hyjyxxFile)
    {
        startPage();
        List<HyjyxxFile> list = hyjyxxFileService.selectHyjyxxFileList(hyjyxxFile);
        return getDataTable(list);
    }

    /**
     * 导出会议纪要_附件列表
     */
    @Log(title = "会议纪要_附件", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, HyjyxxFile hyjyxxFile)
    {
        List<HyjyxxFile> list = hyjyxxFileService.selectHyjyxxFileList(hyjyxxFile);
        ExcelUtil<HyjyxxFile> util = new ExcelUtil<HyjyxxFile>(HyjyxxFile.class);
        util.exportExcel(response, list, "会议纪要_附件数据");
    }

    /**
     * 获取会议纪要_附件详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(hyjyxxFileService.selectHyjyxxFileById(id));
    }

    /**
     * 新增会议纪要_附件
     */
    @Log(title = "会议纪要_附件", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody HyjyxxFile hyjyxxFile)
    {
        return toAjax(hyjyxxFileService.insertHyjyxxFile(hyjyxxFile));
    }

    /**
     * 修改会议纪要_附件
     */
    @Log(title = "会议纪要_附件", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody HyjyxxFile hyjyxxFile)
    {
        return toAjax(hyjyxxFileService.updateHyjyxxFile(hyjyxxFile));
    }

    /**
     * 删除会议纪要_附件
     */
    @Log(title = "会议纪要_附件", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(hyjyxxFileService.deleteHyjyxxFileByIds(ids));
    }
}
