package com.ruoyi.project.ys.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.ys.mapper.HyjyxxMbMapper;
import com.ruoyi.project.ys.domain.HyjyxxMb;
import com.ruoyi.project.ys.service.IHyjyxxMbService;

import static com.ruoyi.common.utils.SecurityUtils.getUserId;

/**
 * 会议模板Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-17
 */
@Service
public class HyjyxxMbServiceImpl implements IHyjyxxMbService 
{
    @Autowired
    private HyjyxxMbMapper hyjyxxMbMapper;

    /**
     * 查询会议模板
     * 
     * @param id 会议模板主键
     * @return 会议模板
     */
    @Override
    public HyjyxxMb selectHyjyxxMbById(Long id)
    {
        return hyjyxxMbMapper.selectHyjyxxMbById(id);
    }

    /**
     * 查询会议模板列表
     * 
     * @param hyjyxxMb 会议模板
     * @return 会议模板
     */
    @Override
    public List<HyjyxxMb> selectHyjyxxMbList(HyjyxxMb hyjyxxMb)
    {
        return hyjyxxMbMapper.selectHyjyxxMbList(hyjyxxMb);
    }

    /**
     * 新增会议模板
     * 
     * @param hyjyxxMb 会议模板
     * @return 结果
     */
    @Override
    public int insertHyjyxxMb(HyjyxxMb hyjyxxMb)
    {
        hyjyxxMb.setCreateBy(getUserId()+"");
        hyjyxxMb.setCreatedTime(DateUtils.getNowDate());
        return hyjyxxMbMapper.insertHyjyxxMb(hyjyxxMb);
    }

    /**
     * 修改会议模板
     * 
     * @param hyjyxxMb 会议模板
     * @return 结果
     */
    @Override
    public int updateHyjyxxMb(HyjyxxMb hyjyxxMb)
    {
        hyjyxxMb.setUpdateBy(getUserId()+"");
        hyjyxxMb.setUpdateTime(DateUtils.getNowDate());
        return hyjyxxMbMapper.updateHyjyxxMb(hyjyxxMb);
    }

    /**
     * 批量删除会议模板
     * 
     * @param ids 需要删除的会议模板主键
     * @return 结果
     */
    @Override
    public int deleteHyjyxxMbByIds(Long[] ids)
    {
        return hyjyxxMbMapper.deleteHyjyxxMbByIds(ids);
    }

    /**
     * 删除会议模板信息
     * 
     * @param id 会议模板主键
     * @return 结果
     */
    @Override
    public int deleteHyjyxxMbById(Long id)
    {
        return hyjyxxMbMapper.deleteHyjyxxMbById(id);
    }
}
