package com.ruoyi.project.ys.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 验收前期-项目信息-项目成员对象 ysqq_xmxx_xmcy
 * 
 * @author ruoyi
 * @date 2025-10-30
 */
public class YsqqXmxxXmcy extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long cyid;

    /** 项目id */
    @Excel(name = "项目id")
    private Long zbid;

    /** 用户ID */
    @Excel(name = "用户ID")
    private Long userId;

    /** 用户账号 */
    @Excel(name = "用户姓名")
    private String nickName;

    /** 项目角色 */
    @Excel(name = "项目角色")
    private String xmjs;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    /** 备用1 */
    @Excel(name = "备用1")
    private String ext1;

    /** 备用2 */
    @Excel(name = "备用2")
    private String ext2;

    /** 备用3 */
    @Excel(name = "备用3")
    private String ext3;

    public void setCyid(Long cyid) 
    {
        this.cyid = cyid;
    }

    public Long getCyid() 
    {
        return cyid;
    }

    public void setZbid(Long zbid) 
    {
        this.zbid = zbid;
    }

    public Long getZbid() 
    {
        return zbid;
    }

    public void setUserId(Long userId) 
    {
        this.userId = userId;
    }

    public Long getUserId() 
    {
        return userId;
    }



    public void setXmjs(String xmjs) 
    {
        this.xmjs = xmjs;
    }

    public String getXmjs() 
    {
        return xmjs;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    public void setExt1(String ext1) 
    {
        this.ext1 = ext1;
    }

    public String getExt1() 
    {
        return ext1;
    }

    public void setExt2(String ext2) 
    {
        this.ext2 = ext2;
    }

    public String getExt2() 
    {
        return ext2;
    }

    public void setExt3(String ext3) 
    {
        this.ext3 = ext3;
    }

    public String getExt3() 
    {
        return ext3;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("cyid", getCyid())
            .append("zbid", getZbid())
            .append("userId", getUserId())
            .append("nickName", getNickName())
            .append("xmjs", getXmjs())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("ext1", getExt1())
            .append("ext2", getExt2())
            .append("ext3", getExt3())
            .toString();
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }
}
